/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.impl.blockfrost.service;

import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.http.TransactionApi;
import com.bloxbean.cardano.client.backend.model.Result;
import com.bloxbean.cardano.client.backend.model.TransactionContent;
import com.bloxbean.cardano.client.backend.model.TxContentUtxo;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Response;

public class BFTransactionService
extends BFBaseService
implements TransactionService {
    private TransactionApi transactionApi = (TransactionApi)this.getRetrofit().create(TransactionApi.class);

    public BFTransactionService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    @Override
    public Result<String> submitTransaction(byte[] cborData) throws ApiException {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/cbor"), (byte[])cborData);
        Call<String> txnCall = this.transactionApi.submit(this.getProjectId(), requestBody);
        try {
            Response response = txnCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error submit transaction", e);
        }
    }

    @Override
    public Result<TransactionContent> getTransaction(String txnHash) throws ApiException {
        Call<TransactionContent> txnCall = this.transactionApi.getTransaction(this.getProjectId(), txnHash);
        try {
            Response response = txnCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting transaction for id : " + txnHash, e);
        }
    }

    @Override
    public Result<TxContentUtxo> getTransactionUtxos(String txnHash) throws ApiException {
        Call<TxContentUtxo> txnCall = this.transactionApi.getTransactionUtxos(this.getProjectId(), txnHash);
        try {
            Response response = txnCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting transaction utxos for id : " + txnHash, e);
        }
    }
}

