/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.impl.blockfrost.service;

import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.common.OrderEnum;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.http.AddressesApi;
import com.bloxbean.cardano.client.backend.model.Result;
import com.bloxbean.cardano.client.backend.model.Utxo;
import java.io.IOException;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

public class BFUtxoService
extends BFBaseService
implements UtxoService {
    private AddressesApi addressApi = (AddressesApi)this.getRetrofit().create(AddressesApi.class);

    public BFUtxoService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    @Override
    public Result<List<Utxo>> getUtxos(String address, int count, int page) throws ApiException {
        return this.getUtxos(address, count, page, OrderEnum.asc);
    }

    @Override
    public Result<List<Utxo>> getUtxos(String address, int count, int page, OrderEnum order) throws ApiException {
        Call<List<Utxo>> utxosCall = this.addressApi.getUtxos(this.getProjectId(), address, count, page, order.toString());
        try {
            Response response = utxosCall.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting utxos", e);
        }
    }
}

