/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.model;

public class Result<T> {
    boolean successful;
    String response;
    int code;
    T value;

    private Result(boolean successful) {
        this.successful = successful;
    }

    private Result(boolean successful, String response) {
        this.successful = successful;
        this.response = response;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public T getValue() {
        return this.value;
    }

    public Result withValue(T value) {
        this.value = value;
        return this;
    }

    public static Result error() {
        return new Result(false);
    }

    public static Result error(String response) {
        return new Result(false, response);
    }

    public static Result create(boolean status, String response) {
        return new Result(status, response);
    }

    public static Result success(String response) {
        return new Result(true, response);
    }

    public Result code(int code) {
        this.code = code;
        return this;
    }

    public int code() {
        return this.code;
    }

    public String toString() {
        return "Result{successful=" + this.successful + ", response='" + this.response + '\'' + ", code=" + this.code + ", value=" + this.value + '}';
    }
}

