/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.model;

import com.bloxbean.cardano.client.backend.model.Amount;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Utxo {
    private String txHash;
    private int outputIndex;
    private List<Amount> amount;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Utxo utxo = (Utxo)o;
        return this.outputIndex == utxo.outputIndex && this.txHash.equals(utxo.txHash);
    }

    public int hashCode() {
        return Objects.hash(this.txHash, this.outputIndex);
    }

    public static UtxoBuilder builder() {
        return new UtxoBuilder();
    }

    public String getTxHash() {
        return this.txHash;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public List<Amount> getAmount() {
        return this.amount;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public void setOutputIndex(int outputIndex) {
        this.outputIndex = outputIndex;
    }

    public void setAmount(List<Amount> amount) {
        this.amount = amount;
    }

    public String toString() {
        return "Utxo(txHash=" + this.getTxHash() + ", outputIndex=" + this.getOutputIndex() + ", amount=" + this.getAmount() + ")";
    }

    public Utxo() {
    }

    public Utxo(String txHash, int outputIndex, List<Amount> amount) {
        this.txHash = txHash;
        this.outputIndex = outputIndex;
        this.amount = amount;
    }

    public static class UtxoBuilder {
        private String txHash;
        private int outputIndex;
        private List<Amount> amount;

        UtxoBuilder() {
        }

        public UtxoBuilder txHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        public UtxoBuilder outputIndex(int outputIndex) {
            this.outputIndex = outputIndex;
            return this;
        }

        public UtxoBuilder amount(List<Amount> amount) {
            this.amount = amount;
            return this;
        }

        public Utxo build() {
            return new Utxo(this.txHash, this.outputIndex, this.amount);
        }

        public String toString() {
            return "Utxo.UtxoBuilder(txHash=" + this.txHash + ", outputIndex=" + this.outputIndex + ", amount=" + this.amount + ")";
        }
    }
}

