/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cli;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.common.model.Networks;
import picocli.CommandLine;

@CommandLine.Command(name="generate", description={"Generate accounts"})
public class AccountGeneration
implements Runnable {
    @CommandLine.Option(names={"-n", "--network"}, description={"Network [mainnet | testnet]"})
    private String network;
    @CommandLine.Option(names={"-t", "--total"}, description={"Total number of accounts to generate"})
    private int total;
    @CommandLine.Option(names={"-ea", "--enterprise-address"}, description={"Generate enterprise address"})
    private boolean entAddress;

    @Override
    public void run() {
        if (this.network == null || this.network.trim().length() == 0) {
            this.network = "mainnet";
        }
        Account account = null;
        account = "testnet".equals(this.network) ? new Account(Networks.testnet()) : new Account();
        String mnemonic = account.mnemonic();
        System.out.println("Mnemonic  : " + mnemonic);
        for (int i = 0; i <= this.total; ++i) {
            System.out.println(" ");
            account = null;
            account = "testnet".equals(this.network) ? new Account(Networks.testnet(), mnemonic, i) : new Account(mnemonic, i);
            System.out.println("Base Address-" + i + ": " + account.baseAddress());
            if (!this.entAddress) continue;
            System.out.println("Ent Address -" + i + ": " + account.enterpriseAddress());
        }
    }
}

