/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cli;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.common.model.Networks;
import picocli.CommandLine;

@CommandLine.Command(name="from-mnemonic", description={"Generate account(s) from mnemonic"})
public class FromMnemonic
implements Runnable {
    @CommandLine.Option(names={"-mn", "--mnemonic"}, description={"Mnemonic"}, required=true)
    private String mnemonic;
    @CommandLine.Option(names={"-n", "--network"}, description={"Network [mainnet | testnet]"})
    private String network;
    @CommandLine.Option(names={"-t", "--total"}, description={"Total number of accounts to generate"})
    private int total;
    @CommandLine.Option(names={"-ea", "--enterprise-address"}, description={"Generate enterprise address"})
    private boolean entAddress;

    @Override
    public void run() {
        if (this.network == null || this.network.trim().length() == 0) {
            this.network = "mainnet";
        }
        Account account = null;
        account = "testnet".equals(this.network) ? new Account((Network)Networks.testnet(), this.mnemonic) : new Account(this.mnemonic);
        for (int i = 0; i <= this.total; ++i) {
            account = null;
            account = "testnet".equals(this.network) ? new Account(Networks.testnet(), this.mnemonic, i) : new Account(this.mnemonic, i);
            System.out.println(" ");
            System.out.println("Base Address-" + i + ": " + account.baseAddress());
            if (!this.entAddress) continue;
            System.out.println("Ent Address -" + i + ": " + account.enterpriseAddress());
        }
    }
}

