/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.common;

import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import java.math.BigInteger;

public class MinAdaCalculator {
    private BigInteger minUtxoValue;
    int adaOnlyUtxoSize = 27;
    int utxoEntrySizeWithoutVal = 27;

    public MinAdaCalculator(BigInteger minUtxoValue) {
        this.minUtxoValue = minUtxoValue;
    }

    public BigInteger calculateMinAda(TransactionOutput output) {
        long b;
        if (output.getValue().getMultiAssets() == null || output.getValue().getMultiAssets().size() == 0) {
            return this.minUtxoValue;
        }
        int numAssets = 0;
        int numPIDs = 0;
        long sumAssetNameLengths = 0L;
        int pidSize = 28;
        for (MultiAsset ma : output.getValue().getMultiAssets()) {
            ++numPIDs;
            for (Asset asset : ma.getAssets()) {
                ++numAssets;
                sumAssetNameLengths += (long)asset.getNameAsBytes().length;
            }
        }
        long sizeB = this.calculateSizeB(numAssets, sumAssetNameLengths, numPIDs, pidSize);
        BigInteger a = this.minUtxoValue.divide(BigInteger.valueOf(this.adaOnlyUtxoSize));
        BigInteger value = a.multiply(BigInteger.valueOf(b = (long)this.utxoEntrySizeWithoutVal + sizeB));
        if (value.compareTo(this.minUtxoValue) == 1) {
            return value;
        }
        return this.minUtxoValue;
    }

    private long calculateSizeB(long numAssets, long sumAssetNameLengths, int numPIDs, int pidSize) {
        long totalBytes = numAssets * 12L + sumAssetNameLengths + (long)(numPIDs * pidSize);
        return 6L + this.roundupBytesToWords(totalBytes);
    }

    private long roundupBytesToWords(long noOfBytes) {
        return (noOfBytes + 7L) / 8L;
    }
}

