/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.crypto;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.util.HexUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class KeyGenCborUtil {
    public static String bytesToCbor(byte[] bytes) throws CborSerializationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CborBuilder cborBuilder = new CborBuilder();
        try {
            List dataItems = cborBuilder.add(bytes).build();
            new CborEncoder((OutputStream)baos).nonCanonical().encode(dataItems);
            byte[] encodedBytes = baos.toByteArray();
            return Hex.toHexString((byte[])encodedBytes);
        }
        catch (CborException e) {
            throw new CborSerializationException("Cbor serialization error", (Exception)((Object)e));
        }
    }

    public static byte[] cborToBytes(String cbor) throws CborDeserializationException {
        List dataItemList = null;
        try {
            dataItemList = CborDecoder.decode((byte[])HexUtil.decodeHexString(cbor));
        }
        catch (CborException e) {
            throw new CborDeserializationException("Cbor deserialization error", (Exception)((Object)e));
        }
        byte[] bytes = ((ByteString)dataItemList.get(0)).getBytes();
        return bytes;
    }
}

