/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.crypto;

import com.bloxbean.cardano.client.crypto.KeyGenCborUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationKey {
    private static final Logger LOG = LoggerFactory.getLogger(VerificationKey.class);
    private String type = "PaymentVerificationKeyShelley_ed25519";
    private String description = "Payment Verification Key";
    private String cborHex;
    @JsonIgnore
    private byte[] bytes;

    public VerificationKey() {
    }

    public VerificationKey(String cborHex) {
        this();
        this.cborHex = cborHex;
    }

    public byte[] getBytes() {
        if (this.cborHex != null) {
            try {
                return KeyGenCborUtil.cborToBytes(this.cborHex);
            }
            catch (Exception e) {
                LOG.error("Cbor decode error", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static VerificationKey create(byte[] bytes) throws CborSerializationException {
        String cbor = KeyGenCborUtil.bytesToCbor(bytes);
        return new VerificationKey(cbor);
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCborHex() {
        return this.cborHex;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCborHex(String cborHex) {
        this.cborHex = cborHex;
    }

    @JsonIgnore
    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VerificationKey)) {
            return false;
        }
        VerificationKey other = (VerificationKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$cborHex = this.getCborHex();
        String other$cborHex = other.getCborHex();
        if (this$cborHex == null ? other$cborHex != null : !this$cborHex.equals(other$cborHex)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof VerificationKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $cborHex = this.getCborHex();
        result = result * 59 + ($cborHex == null ? 43 : $cborHex.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBytes());
        return result;
    }

    public String toString() {
        return "VerificationKey(type=" + this.getType() + ", description=" + this.getDescription() + ", cborHex=" + this.getCborHex() + ", bytes=" + Arrays.toString(this.getBytes()) + ")";
    }
}

