/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.jna;

import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.exception.AddressRuntimeException;
import com.bloxbean.cardano.client.jna.CardanoJNA;
import com.bloxbean.cardano.client.util.HexUtil;
import com.sun.jna.Pointer;

public class CardanoJNAUtil {
    public static String getBaseAddress(String phrase, int index, boolean isTestnet) {
        Pointer pointer = CardanoJNA.INSTANCE.getBaseAddress(phrase, index, isTestnet);
        String result = pointer.getString(0L);
        CardanoJNA.INSTANCE.dropCharPointer(pointer);
        return result;
    }

    public static String getBaseAddressByNetwork(String phrase, int index, Network.ByReference network) {
        Pointer pointer = CardanoJNA.INSTANCE.getBaseAddressByNetwork(phrase, index, network);
        String result = pointer.getString(0L);
        CardanoJNA.INSTANCE.dropCharPointer(pointer);
        return result;
    }

    public static String getEnterpriseAddress(String phrase, int index, boolean isTestnet) {
        Pointer pointer = CardanoJNA.INSTANCE.getEnterpriseAddress(phrase, index, isTestnet);
        String result = pointer.getString(0L);
        CardanoJNA.INSTANCE.dropCharPointer(pointer);
        return result;
    }

    public static String getEnterpriseAddressByNetwork(String phrase, int index, Network.ByReference network) {
        Pointer pointer = CardanoJNA.INSTANCE.getEnterpriseAddressByNetwork(phrase, index, network);
        String result = pointer.getString(0L);
        CardanoJNA.INSTANCE.dropCharPointer(pointer);
        return result;
    }

    public static String generateMnemonic() {
        Pointer pointer = CardanoJNA.INSTANCE.generateMnemonic();
        String result = pointer.getString(0L);
        CardanoJNA.INSTANCE.dropCharPointer(pointer);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPrivateKeyFromMnemonic(String phrase, int index) {
        Pointer pointer = CardanoJNA.INSTANCE.getPrivateKeyFromMnemonic(phrase, index);
        String result = pointer.getString(0L);
        try {
            if (result == null || result.isEmpty()) {
                throw new AddressRuntimeException("Unable to get private key from mnemonic phrase");
            }
            String string = result;
            return string;
        }
        finally {
            CardanoJNA.INSTANCE.dropCharPointer(pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getPrivateKeyBytesFromMnemonic(String phrase, int index) {
        Pointer pointer = CardanoJNA.INSTANCE.getPrivateKeyBytesFromMnemonic(phrase, index);
        try {
            String result = pointer.getString(0L);
            if (result == null || result.isEmpty()) {
                throw new AddressRuntimeException("Unable to get private key bytes from mnemonic phrase");
            }
            byte[] byArray = HexUtil.decodeHexString(result);
            return byArray;
        }
        finally {
            CardanoJNA.INSTANCE.dropCharPointer(pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getPublicKeyBytesFromMnemonic(String phrase, int index) {
        Pointer pointer = CardanoJNA.INSTANCE.getPublicKeyBytesFromMnemonic(phrase, index);
        try {
            String result = pointer.getString(0L);
            if (result == null || result.isEmpty()) {
                throw new AddressRuntimeException("Unable to get public key bytes from mnemonic phrase");
            }
            byte[] byArray = HexUtil.decodeHexString(result);
            return byArray;
        }
        finally {
            CardanoJNA.INSTANCE.dropCharPointer(pointer);
        }
    }

    public static String bech32AddressToBytes(String bech32Address) {
        Pointer pointer = CardanoJNA.INSTANCE.bech32AddressToBytes(bech32Address);
        String result = pointer.getString(0L);
        CardanoJNA.INSTANCE.dropCharPointer(pointer);
        return result;
    }

    public static String hexBytesToBech32Address(String addressBytesInHex) {
        Pointer pointer = CardanoJNA.INSTANCE.hexBytesToBech32Address(addressBytesInHex);
        String result = pointer.getString(0L);
        CardanoJNA.INSTANCE.dropCharPointer(pointer);
        return result;
    }

    public static String sign(String rawTxnInHex, String privateKey) {
        Pointer pointer = CardanoJNA.INSTANCE.sign(rawTxnInHex, privateKey);
        String result = pointer.getString(0L);
        CardanoJNA.INSTANCE.dropCharPointer(pointer);
        return result;
    }

    public static String signWithSecretKey(String rawTxnInHex, String privateKey) {
        Pointer pointer = CardanoJNA.INSTANCE.signWithSecretKey(rawTxnInHex, privateKey);
        String result = pointer.getString(0L);
        CardanoJNA.INSTANCE.dropCharPointer(pointer);
        return result;
    }

    public static boolean validateTransactionCBOR(String rawTxnInHex) {
        return CardanoJNA.INSTANCE.validateTransactionCBOR(rawTxnInHex);
    }
}

