/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.cbor;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.crypto.KeyGenUtil;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import com.bloxbean.cardano.client.metadata.exception.MetadataDeSerializationException;
import com.bloxbean.cardano.client.metadata.exception.MetadataSerializationException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collection;

public class CBORMetadata
implements Metadata {
    private Map map = new Map();

    public CBORMetadata put(BigInteger key, BigInteger value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new UnsignedInteger(value));
        return this;
    }

    public CBORMetadata putNegative(BigInteger key, BigInteger value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new NegativeInteger(value));
        return this;
    }

    public CBORMetadata put(BigInteger key, byte[] value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new ByteString(value));
        return this;
    }

    public CBORMetadata put(BigInteger key, String value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new UnicodeString(value));
        return this;
    }

    public CBORMetadata put(BigInteger key, CBORMetadataMap mm) {
        if (this.map != null) {
            this.map.put((DataItem)new UnsignedInteger(key), (DataItem)mm.getMap());
        }
        return this;
    }

    public CBORMetadata put(BigInteger key, CBORMetadataList list) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)list.getArray());
        return this;
    }

    @Override
    public Map getData() throws MetadataSerializationException {
        return this.map;
    }

    @Override
    public byte[] serialize() throws MetadataSerializationException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CborBuilder cborBuilder = new CborBuilder();
            cborBuilder.add((DataItem)this.map);
            new CborEncoder((OutputStream)baos).nonCanonical().encode(cborBuilder.build());
            byte[] encodedBytes = baos.toByteArray();
            return encodedBytes;
        }
        catch (Exception ex) {
            throw new MetadataSerializationException("CBOR serialization exception ", ex);
        }
    }

    public static CBORMetadata deserialize(Map metadataMap) throws MetadataDeSerializationException {
        CBORMetadata cborMetadata = new CBORMetadata();
        Collection keys = metadataMap.getKeys();
        for (DataItem keyDI : keys) {
            DataItem valueDI = metadataMap.get(keyDI);
            BigInteger key = ((UnsignedInteger)keyDI).getValue();
            if (MajorType.UNSIGNED_INTEGER.equals((Object)valueDI.getMajorType())) {
                cborMetadata.put(key, ((UnsignedInteger)valueDI).getValue());
                continue;
            }
            if (MajorType.NEGATIVE_INTEGER.equals((Object)valueDI.getMajorType())) {
                cborMetadata.put(key, ((NegativeInteger)valueDI).getValue());
                continue;
            }
            if (MajorType.BYTE_STRING.equals((Object)valueDI.getMajorType())) {
                cborMetadata.put(key, ((ByteString)valueDI).getBytes());
                continue;
            }
            if (MajorType.UNICODE_STRING.equals((Object)valueDI.getMajorType())) {
                cborMetadata.put(key, ((UnicodeString)valueDI).getString());
                continue;
            }
            if (MajorType.MAP.equals((Object)valueDI.getMajorType())) {
                CBORMetadataMap cborMetadataMap = new CBORMetadataMap((Map)valueDI);
                cborMetadata.put(key, cborMetadataMap);
                continue;
            }
            if (MajorType.ARRAY.equals((Object)valueDI.getMajorType())) {
                CBORMetadataList cborMetadataList = new CBORMetadataList((Array)valueDI);
                cborMetadata.put(key, cborMetadataList);
                continue;
            }
            throw new MetadataDeSerializationException("Unsupported type : " + valueDI.getMajorType());
        }
        return cborMetadata;
    }

    @Override
    public byte[] getMetadataHash() throws MetadataSerializationException {
        byte[] encodedBytes = this.serialize();
        return KeyGenUtil.blake2bHash256(encodedBytes);
    }
}

