/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.cbor;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import java.math.BigInteger;

public class CBORMetadataList {
    Array array;

    public CBORMetadataList() {
        this.array = new Array();
    }

    public CBORMetadataList(Array array) {
        this.array = array;
    }

    public CBORMetadataList add(BigInteger value) {
        this.array.add((DataItem)new UnsignedInteger(value));
        return this;
    }

    public CBORMetadataList addNegative(BigInteger value) {
        this.array.add((DataItem)new NegativeInteger(value));
        return this;
    }

    public CBORMetadataList add(String value) {
        this.array.add((DataItem)new UnicodeString(value));
        return this;
    }

    public CBORMetadataList add(byte[] value) {
        this.array.add((DataItem)new ByteString(value));
        return this;
    }

    public CBORMetadataList add(CBORMetadataMap map) {
        if (map != null) {
            this.array.add((DataItem)map.getMap());
        }
        return this;
    }

    public CBORMetadataList add(CBORMetadataList list) {
        if (list != null) {
            this.array.add((DataItem)list.getArray());
        }
        return this;
    }

    public CBORMetadataList MetadataList(CBORMetadataList list) {
        if (list != null) {
            this.array.add((DataItem)list.getArray());
        }
        return this;
    }

    Array getArray() {
        return this.array;
    }
}

