/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.cbor;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;
import java.math.BigInteger;

public class CBORMetadataMap {
    private Map map;

    public CBORMetadataMap() {
        this.map = new Map();
    }

    public CBORMetadataMap(Map map) {
        this.map = map;
    }

    public CBORMetadataMap put(BigInteger key, BigInteger value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new UnsignedInteger(value));
        return this;
    }

    public CBORMetadataMap putNegative(BigInteger key, BigInteger value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new NegativeInteger(value));
        return this;
    }

    public CBORMetadataMap put(BigInteger key, byte[] value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new ByteString(value));
        return this;
    }

    public CBORMetadataMap put(BigInteger key, String value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new UnicodeString(value));
        return this;
    }

    public CBORMetadataMap put(BigInteger key, CBORMetadataMap value) {
        if (value != null) {
            this.map.put((DataItem)new UnsignedInteger(key), (DataItem)value.getMap());
        }
        return this;
    }

    public CBORMetadataMap put(BigInteger key, CBORMetadataList list) {
        if (list != null) {
            this.map.put((DataItem)new UnsignedInteger(key), (DataItem)list.getArray());
        }
        return this;
    }

    public CBORMetadataMap put(String key, BigInteger value) {
        this.map.put((DataItem)new UnicodeString(key), (DataItem)new UnsignedInteger(value));
        return this;
    }

    public CBORMetadataMap putNegative(String key, BigInteger value) {
        this.map.put((DataItem)new UnicodeString(key), (DataItem)new NegativeInteger(value));
        return this;
    }

    public CBORMetadataMap put(String key, byte[] value) {
        this.map.put((DataItem)new UnicodeString(key), (DataItem)new ByteString(value));
        return this;
    }

    public CBORMetadataMap put(String key, String value) {
        this.map.put((DataItem)new UnicodeString(key), (DataItem)new UnicodeString(value));
        return this;
    }

    public CBORMetadataMap put(String key, CBORMetadataMap value) {
        if (value != null) {
            this.map.put((DataItem)new UnicodeString(key), (DataItem)value.getMap());
        }
        return this;
    }

    public CBORMetadataMap put(String key, CBORMetadataList list) {
        if (list != null) {
            this.map.put((DataItem)new UnicodeString(key), (DataItem)list.getArray());
        }
        return this;
    }

    public CBORMetadataMap put(byte[] key, BigInteger value) {
        this.map.put((DataItem)new ByteString(key), (DataItem)new UnsignedInteger(value));
        return this;
    }

    public CBORMetadataMap putNegative(byte[] key, BigInteger value) {
        this.map.put((DataItem)new ByteString(key), (DataItem)new NegativeInteger(value));
        return this;
    }

    public CBORMetadataMap put(byte[] key, byte[] value) {
        this.map.put((DataItem)new ByteString(key), (DataItem)new ByteString(value));
        return this;
    }

    public CBORMetadataMap put(byte[] key, String value) {
        this.map.put((DataItem)new ByteString(key), (DataItem)new UnicodeString(value));
        return this;
    }

    public CBORMetadataMap put(byte[] key, CBORMetadataMap value) {
        if (value != null) {
            this.map.put((DataItem)new ByteString(key), (DataItem)value.getMap());
        }
        return this;
    }

    public CBORMetadataMap put(byte[] key, CBORMetadataList list) {
        if (list != null) {
            this.map.put((DataItem)new ByteString(key), (DataItem)list.getArray());
        }
        return this;
    }

    Map getMap() {
        return this.map;
    }
}

