/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.helper;

import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadata;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import com.bloxbean.cardano.client.metadata.exception.JsonMetadaException;
import com.bloxbean.cardano.client.metadata.exception.MetadataSerializationException;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigInteger;
import java.util.Iterator;

public class JsonNoSchemaToMetadataConverter {
    private static ObjectMapper mapper = new ObjectMapper();

    public static Metadata jsonToCborMetadata(String json) throws JsonProcessingException {
        JsonNode jsonNode = mapper.readTree(json);
        if (jsonNode instanceof ObjectNode) {
            return JsonNoSchemaToMetadataConverter.parseTopJsonObject((ObjectNode)jsonNode);
        }
        throw new MetadataSerializationException("Invalid json type : " + jsonNode.getNodeType());
    }

    private static CBORMetadata parseTopJsonObject(ObjectNode objectNode) {
        Iterator fields = objectNode.fieldNames();
        CBORMetadata metadata = new CBORMetadata();
        while (fields.hasNext()) {
            String field = (String)fields.next();
            BigInteger key = new BigInteger(field);
            JsonNode value = objectNode.get(field);
            Object cborValue = JsonNoSchemaToMetadataConverter.processValueNode(value);
            if (cborValue instanceof CBORMetadataMap) {
                metadata.put(key, (CBORMetadataMap)cborValue);
                continue;
            }
            if (cborValue instanceof CBORMetadataList) {
                metadata.put(key, (CBORMetadataList)cborValue);
                continue;
            }
            if (cborValue instanceof BigInteger) {
                BigInteger bi = (BigInteger)cborValue;
                if (bi.compareTo(BigInteger.ZERO) == -1) {
                    metadata.putNegative(key, (BigInteger)cborValue);
                    continue;
                }
                metadata.put(key, (BigInteger)cborValue);
                continue;
            }
            if (cborValue instanceof String) {
                metadata.put(key, (String)cborValue);
                continue;
            }
            if (!(cborValue instanceof byte[])) continue;
            metadata.put(key, (byte[])cborValue);
        }
        return metadata;
    }

    private static CBORMetadataList parseArrayNode(ArrayNode value) {
        CBORMetadataList metadataList = new CBORMetadataList();
        Iterator fields = value.elements();
        while (fields.hasNext()) {
            JsonNode node = (JsonNode)fields.next();
            Object cborValue = JsonNoSchemaToMetadataConverter.processValueNode(node);
            if (cborValue instanceof CBORMetadataMap) {
                metadataList.add((CBORMetadataMap)cborValue);
                continue;
            }
            if (cborValue instanceof CBORMetadataList) {
                metadataList.add((CBORMetadataList)cborValue);
                continue;
            }
            if (cborValue instanceof BigInteger) {
                BigInteger bi = (BigInteger)cborValue;
                if (bi.compareTo(BigInteger.ZERO) == -1) {
                    metadataList.addNegative((BigInteger)cborValue);
                    continue;
                }
                metadataList.add((BigInteger)cborValue);
                continue;
            }
            if (cborValue instanceof String) {
                metadataList.add((String)cborValue);
                continue;
            }
            if (!(cborValue instanceof byte[])) continue;
            metadataList.add((byte[])cborValue);
        }
        return metadataList;
    }

    private static CBORMetadataMap parseObjectNode(ObjectNode jsonObj) {
        CBORMetadataMap metadataMap = new CBORMetadataMap();
        Iterator fields = jsonObj.fieldNames();
        while (fields.hasNext()) {
            String field = (String)fields.next();
            JsonNode nd = jsonObj.get(field);
            Object cborValue = JsonNoSchemaToMetadataConverter.processValueNode(nd);
            if (cborValue instanceof CBORMetadataMap) {
                metadataMap.put(field, (CBORMetadataMap)cborValue);
                continue;
            }
            if (cborValue instanceof CBORMetadataList) {
                metadataMap.put(field, (CBORMetadataList)cborValue);
                continue;
            }
            if (cborValue instanceof BigInteger) {
                BigInteger bi = (BigInteger)cborValue;
                if (bi.compareTo(BigInteger.ZERO) == -1) {
                    metadataMap.putNegative(field, (BigInteger)cborValue);
                    continue;
                }
                metadataMap.put(field, (BigInteger)cborValue);
                continue;
            }
            if (cborValue instanceof String) {
                metadataMap.put(field, (String)cborValue);
                continue;
            }
            if (cborValue instanceof byte[]) {
                metadataMap.put(field, (byte[])cborValue);
                continue;
            }
            throw new JsonMetadaException("Invalid value type : " + cborValue);
        }
        return metadataMap;
    }

    private static Object processValueNode(JsonNode value) {
        if (value instanceof ObjectNode) {
            CBORMetadataMap metadataMap = JsonNoSchemaToMetadataConverter.parseObjectNode((ObjectNode)value);
            return metadataMap;
        }
        if (value instanceof ArrayNode) {
            CBORMetadataList metadataList = JsonNoSchemaToMetadataConverter.parseArrayNode((ArrayNode)value);
            return metadataList;
        }
        if (value instanceof TextNode) {
            String textValue = ((TextNode)value).asText();
            if (textValue.startsWith("0x")) {
                try {
                    byte[] hexValue = HexUtil.decodeHexString(textValue.substring(2));
                    return hexValue;
                }
                catch (Exception e) {
                    throw new JsonMetadaException("Invalid hex value : " + textValue);
                }
            }
            return textValue;
        }
        if (value instanceof NumericNode) {
            BigInteger valueInt = ((NumericNode)value).bigIntegerValue();
            return valueInt;
        }
        throw new JsonMetadaException("Invalid value or value not recognized : " + value);
    }

    private boolean isValidValueType(Object obj) {
        if (obj == null) {
            throw new JsonMetadaException("Null value is not allowed in cbor metadata");
        }
        if (obj instanceof CBORMetadataMap || obj instanceof CBORMetadataList || obj instanceof byte[] || obj instanceof String || obj instanceof BigInteger) {
            return true;
        }
        throw new JsonMetadaException("Invalid value type : " + obj.getClass());
    }
}

