/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.model;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.backend.model.Utxo;
import com.bloxbean.cardano.client.crypto.SecretKey;
import com.bloxbean.cardano.client.transaction.model.TransactionRequest;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.util.List;

public class MintTransaction
extends TransactionRequest {
    private List<MultiAsset> mintAssets;
    @JsonIgnore
    private NativeScript policyScript;
    @JsonIgnore
    private List<SecretKey> policyKeys;

    public MintTransaction(Account sender, String receiver, BigInteger fee, List<Account> additionalWitnessAccounts, List<Utxo> utxosToInclude, List<MultiAsset> mintAssets, NativeScript policyScript, List<SecretKey> policyKeys) {
        super(sender, receiver, fee, additionalWitnessAccounts, utxosToInclude);
        this.mintAssets = mintAssets;
        this.policyScript = policyScript;
        this.policyKeys = policyKeys;
    }

    public static MintTransactionBuilder builder() {
        return new MintTransactionBuilder();
    }

    public List<MultiAsset> getMintAssets() {
        return this.mintAssets;
    }

    public NativeScript getPolicyScript() {
        return this.policyScript;
    }

    public List<SecretKey> getPolicyKeys() {
        return this.policyKeys;
    }

    public void setMintAssets(List<MultiAsset> mintAssets) {
        this.mintAssets = mintAssets;
    }

    @JsonIgnore
    public void setPolicyScript(NativeScript policyScript) {
        this.policyScript = policyScript;
    }

    @JsonIgnore
    public void setPolicyKeys(List<SecretKey> policyKeys) {
        this.policyKeys = policyKeys;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MintTransaction)) {
            return false;
        }
        MintTransaction other = (MintTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<MultiAsset> this$mintAssets = this.getMintAssets();
        List<MultiAsset> other$mintAssets = other.getMintAssets();
        if (this$mintAssets == null ? other$mintAssets != null : !((Object)this$mintAssets).equals(other$mintAssets)) {
            return false;
        }
        NativeScript this$policyScript = this.getPolicyScript();
        NativeScript other$policyScript = other.getPolicyScript();
        if (this$policyScript == null ? other$policyScript != null : !this$policyScript.equals(other$policyScript)) {
            return false;
        }
        List<SecretKey> this$policyKeys = this.getPolicyKeys();
        List<SecretKey> other$policyKeys = other.getPolicyKeys();
        return !(this$policyKeys == null ? other$policyKeys != null : !((Object)this$policyKeys).equals(other$policyKeys));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MintTransaction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MultiAsset> $mintAssets = this.getMintAssets();
        result = result * 59 + ($mintAssets == null ? 43 : ((Object)$mintAssets).hashCode());
        NativeScript $policyScript = this.getPolicyScript();
        result = result * 59 + ($policyScript == null ? 43 : $policyScript.hashCode());
        List<SecretKey> $policyKeys = this.getPolicyKeys();
        result = result * 59 + ($policyKeys == null ? 43 : ((Object)$policyKeys).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MintTransaction(mintAssets=" + this.getMintAssets() + ", policyScript=" + this.getPolicyScript() + ", policyKeys=" + this.getPolicyKeys() + ")";
    }

    public MintTransaction() {
    }

    public MintTransaction(List<MultiAsset> mintAssets, NativeScript policyScript, List<SecretKey> policyKeys) {
        this.mintAssets = mintAssets;
        this.policyScript = policyScript;
        this.policyKeys = policyKeys;
    }

    public static class MintTransactionBuilder {
        private Account sender;
        private String receiver;
        private BigInteger fee;
        private List<Account> additionalWitnessAccounts;
        private List<Utxo> utxosToInclude;
        private List<MultiAsset> mintAssets;
        private NativeScript policyScript;
        private List<SecretKey> policyKeys;

        MintTransactionBuilder() {
        }

        public MintTransactionBuilder sender(Account sender) {
            this.sender = sender;
            return this;
        }

        public MintTransactionBuilder receiver(String receiver) {
            this.receiver = receiver;
            return this;
        }

        public MintTransactionBuilder fee(BigInteger fee) {
            this.fee = fee;
            return this;
        }

        public MintTransactionBuilder additionalWitnessAccounts(List<Account> additionalWitnessAccounts) {
            this.additionalWitnessAccounts = additionalWitnessAccounts;
            return this;
        }

        public MintTransactionBuilder utxosToInclude(List<Utxo> utxosToInclude) {
            this.utxosToInclude = utxosToInclude;
            return this;
        }

        public MintTransactionBuilder mintAssets(List<MultiAsset> mintAssets) {
            this.mintAssets = mintAssets;
            return this;
        }

        public MintTransactionBuilder policyScript(NativeScript policyScript) {
            this.policyScript = policyScript;
            return this;
        }

        public MintTransactionBuilder policyKeys(List<SecretKey> policyKeys) {
            this.policyKeys = policyKeys;
            return this;
        }

        public MintTransaction build() {
            return new MintTransaction(this.sender, this.receiver, this.fee, this.additionalWitnessAccounts, this.utxosToInclude, this.mintAssets, this.policyScript, this.policyKeys);
        }

        public String toString() {
            return "MintTransaction.MintTransactionBuilder(sender=" + this.sender + ", receiver=" + this.receiver + ", fee=" + this.fee + ", additionalWitnessAccounts=" + this.additionalWitnessAccounts + ", utxosToInclude=" + this.utxosToInclude + ", mintAssets=" + this.mintAssets + ", policyScript=" + this.policyScript + ", policyKeys=" + this.policyKeys + ")";
        }
    }
}

