/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.model;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.backend.model.Utxo;
import com.bloxbean.cardano.client.transaction.model.TransactionRequest;
import java.math.BigInteger;
import java.util.List;

public class PaymentTransaction
extends TransactionRequest {
    private String unit;
    private BigInteger amount;

    public PaymentTransaction(Account sender, String receiver, BigInteger fee, List<Account> additionalWitnessAccounts, List<Utxo> utxosToInclude, String unit, BigInteger amount) {
        super(sender, receiver, fee, additionalWitnessAccounts, utxosToInclude);
        this.unit = unit;
        this.amount = amount;
    }

    @Override
    public BigInteger getFee() {
        if (this.fee != null) {
            return this.fee;
        }
        return BigInteger.ZERO;
    }

    public BigInteger getAmount() {
        if (this.amount != null) {
            return this.amount;
        }
        return BigInteger.ZERO;
    }

    public static PaymentTransactionBuilder builder() {
        return new PaymentTransactionBuilder();
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentTransaction)) {
            return false;
        }
        PaymentTransaction other = (PaymentTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        BigInteger this$amount = this.getAmount();
        BigInteger other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaymentTransaction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        BigInteger $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PaymentTransaction(unit=" + this.getUnit() + ", amount=" + this.getAmount() + ")";
    }

    public PaymentTransaction() {
    }

    public PaymentTransaction(String unit, BigInteger amount) {
        this.unit = unit;
        this.amount = amount;
    }

    public static class PaymentTransactionBuilder {
        private Account sender;
        private String receiver;
        private BigInteger fee;
        private List<Account> additionalWitnessAccounts;
        private List<Utxo> utxosToInclude;
        private String unit;
        private BigInteger amount;

        PaymentTransactionBuilder() {
        }

        public PaymentTransactionBuilder sender(Account sender) {
            this.sender = sender;
            return this;
        }

        public PaymentTransactionBuilder receiver(String receiver) {
            this.receiver = receiver;
            return this;
        }

        public PaymentTransactionBuilder fee(BigInteger fee) {
            this.fee = fee;
            return this;
        }

        public PaymentTransactionBuilder additionalWitnessAccounts(List<Account> additionalWitnessAccounts) {
            this.additionalWitnessAccounts = additionalWitnessAccounts;
            return this;
        }

        public PaymentTransactionBuilder utxosToInclude(List<Utxo> utxosToInclude) {
            this.utxosToInclude = utxosToInclude;
            return this;
        }

        public PaymentTransactionBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public PaymentTransactionBuilder amount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        public PaymentTransaction build() {
            return new PaymentTransaction(this.sender, this.receiver, this.fee, this.additionalWitnessAccounts, this.utxosToInclude, this.unit, this.amount);
        }

        public String toString() {
            return "PaymentTransaction.PaymentTransactionBuilder(sender=" + this.sender + ", receiver=" + this.receiver + ", fee=" + this.fee + ", additionalWitnessAccounts=" + this.additionalWitnessAccounts + ", utxosToInclude=" + this.utxosToInclude + ", unit=" + this.unit + ", amount=" + this.amount + ")";
        }
    }
}

