/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class Asset {
    private String name;
    private BigInteger value;

    @JsonIgnore
    public byte[] getNameAsBytes() {
        byte[] assetNameBytes = null;
        if (this.name != null && !this.name.isEmpty()) {
            if (this.name.startsWith("0x")) {
                assetNameBytes = HexUtil.decodeHexString(this.name.substring(2));
            } else {
                try {
                    assetNameBytes = HexUtil.decodeHexString(this.name);
                }
                catch (Exception e) {
                    assetNameBytes = this.name.getBytes(StandardCharsets.UTF_8);
                }
            }
        } else {
            assetNameBytes = new byte[]{};
        }
        return assetNameBytes;
    }

    public String toString() {
        try {
            return "Asset{name=" + this.name + ", value=" + this.value + '}';
        }
        catch (Exception e) {
            return "Asset { Error : " + e.getMessage() + " }";
        }
    }

    public static AssetBuilder builder() {
        return new AssetBuilder();
    }

    public String getName() {
        return this.name;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Asset)) {
            return false;
        }
        Asset other = (Asset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Asset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public Asset(String name, BigInteger value) {
        this.name = name;
        this.value = value;
    }

    public Asset() {
    }

    public static class AssetBuilder {
        private String name;
        private BigInteger value;

        AssetBuilder() {
        }

        public AssetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AssetBuilder value(BigInteger value) {
            this.value = value;
            return this;
        }

        public Asset build() {
            return new Asset(this.name, this.value);
        }

        public String toString() {
            return "Asset.AssetBuilder(name=" + this.name + ", value=" + this.value + ")";
        }
    }
}

