/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.ArrayList;
import java.util.List;

public class MultiAsset {
    private String policyId;
    private List<Asset> assets = new ArrayList<Asset>();

    public void serialize(Map multiAssetMap) {
        Map assetsMap = new Map();
        for (Asset asset : this.assets) {
            ByteString assetNameBytes = new ByteString(asset.getNameAsBytes());
            UnsignedInteger value = new UnsignedInteger(asset.getValue());
            assetsMap.put((DataItem)assetNameBytes, (DataItem)value);
        }
        ByteString policyIdByte = new ByteString(HexUtil.decodeHexString(this.policyId));
        multiAssetMap.put((DataItem)policyIdByte, (DataItem)assetsMap);
    }

    public static MultiAsset deserialize(Map multiAssetsMap, DataItem key) {
        MultiAsset multiAsset = new MultiAsset();
        ByteString keyBS = (ByteString)key;
        multiAsset.setPolicyId(HexUtil.encodeHexString(keyBS.getBytes()));
        Map assetsMap = (Map)multiAssetsMap.get(key);
        for (DataItem assetKey : assetsMap.getKeys()) {
            ByteString assetNameBS = (ByteString)assetKey;
            UnsignedInteger assetValueUI = (UnsignedInteger)assetsMap.get(assetKey);
            String name = HexUtil.encodeHexString(assetNameBS.getBytes());
            multiAsset.getAssets().add(new Asset(name, assetValueUI.getValue()));
        }
        return multiAsset;
    }

    public String toString() {
        try {
            return "MultiAsset{policyId=" + this.policyId + ", assets=" + this.assets + '}';
        }
        catch (Exception e) {
            return "MultiAsset { Error : " + e.getMessage() + " }";
        }
    }

    public static MultiAssetBuilder builder() {
        return new MultiAssetBuilder();
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public void setAssets(List<Asset> assets) {
        this.assets = assets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiAsset)) {
            return false;
        }
        MultiAsset other = (MultiAsset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$policyId = this.getPolicyId();
        String other$policyId = other.getPolicyId();
        if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
            return false;
        }
        List<Asset> this$assets = this.getAssets();
        List<Asset> other$assets = other.getAssets();
        return !(this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiAsset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $policyId = this.getPolicyId();
        result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
        List<Asset> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
        return result;
    }

    public MultiAsset(String policyId, List<Asset> assets) {
        this.policyId = policyId;
        this.assets = assets;
    }

    public MultiAsset() {
    }

    public static class MultiAssetBuilder {
        private String policyId;
        private List<Asset> assets;

        MultiAssetBuilder() {
        }

        public MultiAssetBuilder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public MultiAssetBuilder assets(List<Asset> assets) {
            this.assets = assets;
            return this;
        }

        public MultiAsset build() {
            return new MultiAsset(this.policyId, this.assets);
        }

        public String toString() {
            return "MultiAsset.MultiAssetBuilder(policyId=" + this.policyId + ", assets=" + this.assets + ")";
        }
    }
}

