/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadata;
import com.bloxbean.cardano.client.transaction.spec.TransactionBody;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.util.HexUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;

public class Transaction {
    private TransactionBody body;
    private TransactionWitnessSet witnessSet;
    private Metadata metadata;

    public byte[] serialize() throws CborSerializationException {
        try {
            Map witnessMap;
            if (this.metadata != null && this.body.getMetadataHash() == null) {
                byte[] metadataHash = this.metadata.getMetadataHash();
                this.body.setMetadataHash(metadataHash);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CborBuilder cborBuilder = new CborBuilder();
            Array array = new Array();
            Map bodyMap = this.body.serialize();
            array.add((DataItem)bodyMap);
            if (this.witnessSet != null) {
                witnessMap = this.witnessSet.serialize();
                array.add((DataItem)witnessMap);
            } else {
                witnessMap = new Map();
                array.add((DataItem)witnessMap);
            }
            if (this.metadata != null) {
                array.add((DataItem)this.metadata.getData());
            } else {
                array.add((DataItem)new ByteString((byte[])null));
            }
            cborBuilder.add((DataItem)array);
            new CborEncoder((OutputStream)baos).nonCanonical().encode(cborBuilder.build());
            byte[] encodedBytes = baos.toByteArray();
            return encodedBytes;
        }
        catch (Exception e) {
            throw new CborSerializationException("CBOR Serialization failed", e);
        }
    }

    public String serializeToHex() throws CborSerializationException {
        try {
            byte[] bytes = this.serialize();
            return HexUtil.encodeHexString(bytes);
        }
        catch (Exception ex) {
            throw new CborSerializationException("CBOR serialization exception", ex);
        }
    }

    public static Transaction deserialize(byte[] bytes) throws CborDeserializationException {
        try {
            List dataItemList = CborDecoder.decode((byte[])bytes);
            Transaction transaction = new Transaction();
            if (dataItemList.size() != 1) {
                throw new CborDeserializationException("Invalid no of dataitems");
            }
            Array array = (Array)dataItemList.get(0);
            List txnItems = array.getDataItems();
            if (txnItems.size() < 3) {
                throw new CborDeserializationException("Invalid no of items");
            }
            DataItem txnBody = (DataItem)txnItems.get(0);
            DataItem witness = (DataItem)txnItems.get(1);
            DataItem metadata = (DataItem)txnItems.get(2);
            if (witness != null) {
                TransactionWitnessSet witnessSet = TransactionWitnessSet.deserialize((Map)witness);
                transaction.setWitnessSet(witnessSet);
            }
            if (MajorType.MAP.equals((Object)metadata.getMajorType())) {
                Map metadataMap = (Map)metadata;
                CBORMetadata cborMetadata = CBORMetadata.deserialize(metadataMap);
                transaction.setMetadata(cborMetadata);
            }
            TransactionBody body = TransactionBody.deserialize((Map)txnBody);
            transaction.setBody(body);
            return transaction;
        }
        catch (Exception e) {
            throw new CborDeserializationException("CBOR deserialization failed", e);
        }
    }

    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    public TransactionBody getBody() {
        return this.body;
    }

    public TransactionWitnessSet getWitnessSet() {
        return this.witnessSet;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setBody(TransactionBody body) {
        this.body = body;
    }

    public void setWitnessSet(TransactionWitnessSet witnessSet) {
        this.witnessSet = witnessSet;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionBody this$body = this.getBody();
        TransactionBody other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        TransactionWitnessSet this$witnessSet = this.getWitnessSet();
        TransactionWitnessSet other$witnessSet = other.getWitnessSet();
        if (this$witnessSet == null ? other$witnessSet != null : !((Object)this$witnessSet).equals(other$witnessSet)) {
            return false;
        }
        Metadata this$metadata = this.getMetadata();
        Metadata other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        TransactionWitnessSet $witnessSet = this.getWitnessSet();
        result = result * 59 + ($witnessSet == null ? 43 : ((Object)$witnessSet).hashCode());
        Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    public String toString() {
        return "Transaction(body=" + this.getBody() + ", witnessSet=" + this.getWitnessSet() + ", metadata=" + this.getMetadata() + ")";
    }

    public Transaction(TransactionBody body, TransactionWitnessSet witnessSet, Metadata metadata) {
        this.body = body;
        this.witnessSet = witnessSet;
        this.metadata = metadata;
    }

    public Transaction() {
    }

    public static class TransactionBuilder {
        private TransactionBody body;
        private TransactionWitnessSet witnessSet;
        private Metadata metadata;

        TransactionBuilder() {
        }

        public TransactionBuilder body(TransactionBody body) {
            this.body = body;
            return this;
        }

        public TransactionBuilder witnessSet(TransactionWitnessSet witnessSet) {
            this.witnessSet = witnessSet;
            return this;
        }

        public TransactionBuilder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Transaction build() {
            return new Transaction(this.body, this.witnessSet, this.metadata);
        }

        public String toString() {
            return "Transaction.TransactionBuilder(body=" + this.body + ", witnessSet=" + this.witnessSet + ", metadata=" + this.metadata + ")";
        }
    }
}

