/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TransactionBody {
    private List<TransactionInput> inputs;
    private List<TransactionOutput> outputs;
    private BigInteger fee;
    private long ttl;
    private List<MultiAsset> mint = new ArrayList<MultiAsset>();
    private byte[] metadataHash;
    private long validityStartInterval;

    public Map serialize() throws CborSerializationException, AddressExcepion {
        Map bodyMap = new Map();
        Array inputsArray = new Array();
        for (TransactionInput transactionInput : this.inputs) {
            Array input = transactionInput.serialize();
            inputsArray.add((DataItem)input);
        }
        bodyMap.put((DataItem)new UnsignedInteger(0L), (DataItem)inputsArray);
        Array outputsArray = new Array();
        for (TransactionOutput to : this.outputs) {
            Array output = to.serialize();
            outputsArray.add((DataItem)output);
        }
        bodyMap.put((DataItem)new UnsignedInteger(1L), (DataItem)outputsArray);
        bodyMap.put((DataItem)new UnsignedInteger(2L), (DataItem)new UnsignedInteger(this.fee));
        if (this.ttl != 0L) {
            bodyMap.put((DataItem)new UnsignedInteger(3L), (DataItem)new UnsignedInteger(this.ttl));
        }
        if (this.metadataHash != null) {
            bodyMap.put((DataItem)new UnsignedInteger(7L), (DataItem)new ByteString(this.metadataHash));
        }
        if (this.validityStartInterval != 0L) {
            bodyMap.put((DataItem)new UnsignedInteger(8L), (DataItem)new UnsignedInteger(this.validityStartInterval));
        }
        if (this.mint != null && this.mint.size() > 0) {
            Map map = new Map();
            for (MultiAsset multiAsset : this.mint) {
                multiAsset.serialize(map);
            }
            bodyMap.put((DataItem)new UnsignedInteger(9L), (DataItem)map);
        }
        return bodyMap;
    }

    public static TransactionBody deserialize(Map bodyMap) throws CborDeserializationException {
        Map mintMap;
        UnsignedInteger validityStartIntervalUI;
        ByteString metadataHashBS;
        UnsignedInteger ttlUI;
        TransactionBody transactionBody = new TransactionBody();
        Array inputArray = (Array)bodyMap.get((DataItem)new UnsignedInteger(0L));
        ArrayList<TransactionInput> inputs = new ArrayList<TransactionInput>();
        for (DataItem inputItem : inputArray.getDataItems()) {
            TransactionInput ti = TransactionInput.deserialize((Array)inputItem);
            inputs.add(ti);
        }
        transactionBody.setInputs(inputs);
        Array outputArray = (Array)bodyMap.get((DataItem)new UnsignedInteger(1L));
        ArrayList<TransactionOutput> outputs = new ArrayList<TransactionOutput>();
        for (DataItem ouptutItem : outputArray.getDataItems()) {
            TransactionOutput to = TransactionOutput.deserialize((Array)ouptutItem);
            outputs.add(to);
        }
        transactionBody.setOutputs(outputs);
        UnsignedInteger feeUI = (UnsignedInteger)bodyMap.get((DataItem)new UnsignedInteger(2L));
        if (feeUI != null) {
            transactionBody.setFee(feeUI.getValue());
        }
        if ((ttlUI = (UnsignedInteger)bodyMap.get((DataItem)new UnsignedInteger(3L))) != null) {
            transactionBody.setTtl(ttlUI.getValue().longValue());
        }
        if ((metadataHashBS = (ByteString)bodyMap.get((DataItem)new UnsignedInteger(7L))) != null) {
            transactionBody.setMetadataHash(metadataHashBS.getBytes());
        }
        if ((validityStartIntervalUI = (UnsignedInteger)bodyMap.get((DataItem)new UnsignedInteger(8L))) != null) {
            transactionBody.setValidityStartInterval(validityStartIntervalUI.getValue().longValue());
        }
        if ((mintMap = (Map)bodyMap.get((DataItem)new UnsignedInteger(9L))) != null) {
            Collection mintDataItems = mintMap.getKeys();
            for (DataItem multiAssetKey : mintDataItems) {
                MultiAsset ma = MultiAsset.deserialize(mintMap, multiAssetKey);
                transactionBody.getMint().add(ma);
            }
        }
        return transactionBody;
    }

    public static TransactionBodyBuilder builder() {
        return new TransactionBodyBuilder();
    }

    public List<TransactionInput> getInputs() {
        return this.inputs;
    }

    public List<TransactionOutput> getOutputs() {
        return this.outputs;
    }

    public BigInteger getFee() {
        return this.fee;
    }

    public long getTtl() {
        return this.ttl;
    }

    public List<MultiAsset> getMint() {
        return this.mint;
    }

    public byte[] getMetadataHash() {
        return this.metadataHash;
    }

    public long getValidityStartInterval() {
        return this.validityStartInterval;
    }

    public void setInputs(List<TransactionInput> inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(List<TransactionOutput> outputs) {
        this.outputs = outputs;
    }

    public void setFee(BigInteger fee) {
        this.fee = fee;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setMint(List<MultiAsset> mint) {
        this.mint = mint;
    }

    public void setMetadataHash(byte[] metadataHash) {
        this.metadataHash = metadataHash;
    }

    public void setValidityStartInterval(long validityStartInterval) {
        this.validityStartInterval = validityStartInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionBody)) {
            return false;
        }
        TransactionBody other = (TransactionBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        if (this.getValidityStartInterval() != other.getValidityStartInterval()) {
            return false;
        }
        List<TransactionInput> this$inputs = this.getInputs();
        List<TransactionInput> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<TransactionOutput> this$outputs = this.getOutputs();
        List<TransactionOutput> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        BigInteger this$fee = this.getFee();
        BigInteger other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        List<MultiAsset> this$mint = this.getMint();
        List<MultiAsset> other$mint = other.getMint();
        if (this$mint == null ? other$mint != null : !((Object)this$mint).equals(other$mint)) {
            return false;
        }
        return Arrays.equals(this.getMetadataHash(), other.getMetadataHash());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        long $validityStartInterval = this.getValidityStartInterval();
        result = result * 59 + (int)($validityStartInterval >>> 32 ^ $validityStartInterval);
        List<TransactionInput> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<TransactionOutput> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        BigInteger $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        List<MultiAsset> $mint = this.getMint();
        result = result * 59 + ($mint == null ? 43 : ((Object)$mint).hashCode());
        result = result * 59 + Arrays.hashCode(this.getMetadataHash());
        return result;
    }

    public String toString() {
        return "TransactionBody(inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", fee=" + this.getFee() + ", ttl=" + this.getTtl() + ", mint=" + this.getMint() + ", metadataHash=" + Arrays.toString(this.getMetadataHash()) + ", validityStartInterval=" + this.getValidityStartInterval() + ")";
    }

    public TransactionBody(List<TransactionInput> inputs, List<TransactionOutput> outputs, BigInteger fee, long ttl, List<MultiAsset> mint, byte[] metadataHash, long validityStartInterval) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.fee = fee;
        this.ttl = ttl;
        this.mint = mint;
        this.metadataHash = metadataHash;
        this.validityStartInterval = validityStartInterval;
    }

    public TransactionBody() {
    }

    public static class TransactionBodyBuilder {
        private List<TransactionInput> inputs;
        private List<TransactionOutput> outputs;
        private BigInteger fee;
        private long ttl;
        private List<MultiAsset> mint;
        private byte[] metadataHash;
        private long validityStartInterval;

        TransactionBodyBuilder() {
        }

        public TransactionBodyBuilder inputs(List<TransactionInput> inputs) {
            this.inputs = inputs;
            return this;
        }

        public TransactionBodyBuilder outputs(List<TransactionOutput> outputs) {
            this.outputs = outputs;
            return this;
        }

        public TransactionBodyBuilder fee(BigInteger fee) {
            this.fee = fee;
            return this;
        }

        public TransactionBodyBuilder ttl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public TransactionBodyBuilder mint(List<MultiAsset> mint) {
            this.mint = mint;
            return this;
        }

        public TransactionBodyBuilder metadataHash(byte[] metadataHash) {
            this.metadataHash = metadataHash;
            return this;
        }

        public TransactionBodyBuilder validityStartInterval(long validityStartInterval) {
            this.validityStartInterval = validityStartInterval;
            return this;
        }

        public TransactionBody build() {
            return new TransactionBody(this.inputs, this.outputs, this.fee, this.ttl, this.mint, this.metadataHash, this.validityStartInterval);
        }

        public String toString() {
            return "TransactionBody.TransactionBodyBuilder(inputs=" + this.inputs + ", outputs=" + this.outputs + ", fee=" + this.fee + ", ttl=" + this.ttl + ", mint=" + this.mint + ", metadataHash=" + Arrays.toString(this.metadataHash) + ", validityStartInterval=" + this.validityStartInterval + ")";
        }
    }
}

