/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.List;

public class TransactionInput {
    private String transactionId;
    private int index;

    public Array serialize() throws CborSerializationException {
        Array inputArray = new Array();
        byte[] transactionIdBytes = HexUtil.decodeHexString(this.transactionId);
        inputArray.add((DataItem)new ByteString(transactionIdBytes));
        inputArray.add((DataItem)new UnsignedInteger((long)this.index));
        return inputArray;
    }

    public static TransactionInput deserialize(Array inputItem) throws CborDeserializationException {
        UnsignedInteger indexUI;
        List items = inputItem.getDataItems();
        if (items == null || items.size() != 2) {
            throw new CborDeserializationException("TransactionInput deserialization failed. Invalid no of DataItems");
        }
        TransactionInput transactionInput = new TransactionInput();
        ByteString txnIdBytes = (ByteString)items.get(0);
        if (txnIdBytes != null) {
            transactionInput.setTransactionId(HexUtil.encodeHexString(txnIdBytes.getBytes()));
        }
        if ((indexUI = (UnsignedInteger)items.get(1)) != null) {
            transactionInput.setIndex(indexUI.getValue().intValue());
        }
        return transactionInput;
    }

    public String toString() {
        try {
            return "TransactionInput{transactionId=" + this.transactionId + ", index=" + this.index + '}';
        }
        catch (Exception e) {
            return "TransactionInput { Error : " + e.getMessage() + " }";
        }
    }

    public static TransactionInputBuilder builder() {
        return new TransactionInputBuilder();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int getIndex() {
        return this.index;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionInput)) {
            return false;
        }
        TransactionInput other = (TransactionInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        return !(this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        return result;
    }

    public TransactionInput(String transactionId, int index) {
        this.transactionId = transactionId;
        this.index = index;
    }

    public TransactionInput() {
    }

    public static class TransactionInputBuilder {
        private String transactionId;
        private int index;

        TransactionInputBuilder() {
        }

        public TransactionInputBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public TransactionInputBuilder index(int index) {
            this.index = index;
            return this;
        }

        public TransactionInput build() {
            return new TransactionInput(this.transactionId, this.index);
        }

        public String toString() {
            return "TransactionInput.TransactionInputBuilder(transactionId=" + this.transactionId + ", index=" + this.index + ")";
        }
    }
}

