/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.Value;
import java.util.List;

public class TransactionOutput {
    private String address;
    private Value value;

    public Array serialize() throws CborSerializationException, AddressExcepion {
        Array array = new Array();
        byte[] addressByte = Account.toBytes(this.address);
        array.add((DataItem)new ByteString(addressByte));
        if (this.value == null) {
            throw new CborSerializationException("Value cannot be null");
        }
        if (this.value.getMultiAssets() != null && this.value.getMultiAssets().size() > 0) {
            Array coinAssetArray = new Array();
            if (this.value.getCoin() != null) {
                coinAssetArray.add((DataItem)new UnsignedInteger(this.value.getCoin()));
            }
            Map valueMap = this.value.serialize();
            coinAssetArray.add((DataItem)valueMap);
            array.add((DataItem)coinAssetArray);
        } else {
            array.add((DataItem)new UnsignedInteger(this.value.getCoin()));
        }
        return array;
    }

    public static TransactionOutput deserialize(Array ouptutItem) throws CborDeserializationException {
        List items = ouptutItem.getDataItems();
        TransactionOutput output = new TransactionOutput();
        if (items == null || items.size() != 2) {
            throw new CborDeserializationException("TransactionOutput deserialization failed. Invalid no of DataItems");
        }
        ByteString addrByteStr = (ByteString)items.get(0);
        if (addrByteStr != null) {
            try {
                output.setAddress(Account.bytesToBech32(addrByteStr.getBytes()));
            }
            catch (Exception e) {
                throw new CborDeserializationException("Bytes cannot be converted to bech32 address", e);
            }
        }
        Value value = null;
        DataItem valueItem = (DataItem)items.get(1);
        if (MajorType.UNSIGNED_INTEGER.equals((Object)valueItem.getMajorType())) {
            value = new Value();
            value.setCoin(((UnsignedInteger)valueItem).getValue());
        } else if (MajorType.ARRAY.equals((Object)valueItem.getMajorType())) {
            Array coinAssetArray = (Array)valueItem;
            value = Value.deserialize(coinAssetArray);
        }
        output.setValue(value);
        return output;
    }

    public String toString() {
        return "TransactionOutput{address='" + this.address + '\'' + ", value=" + this.value + '}';
    }

    public static TransactionOutputBuilder builder() {
        return new TransactionOutputBuilder();
    }

    public String getAddress() {
        return this.address;
    }

    public Value getValue() {
        return this.value;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionOutput)) {
            return false;
        }
        TransactionOutput other = (TransactionOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Value this$value = this.getValue();
        Value other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionOutput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Value $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    public TransactionOutput(String address, Value value) {
        this.address = address;
        this.value = value;
    }

    public TransactionOutput() {
    }

    public static class TransactionOutputBuilder {
        private String address;
        private Value value;

        TransactionOutputBuilder() {
        }

        public TransactionOutputBuilder address(String address) {
            this.address = address;
            return this;
        }

        public TransactionOutputBuilder value(Value value) {
            this.value = value;
            return this;
        }

        public TransactionOutput build() {
            return new TransactionOutput(this.address, this.value);
        }

        public String toString() {
            return "TransactionOutput.TransactionOutputBuilder(address=" + this.address + ", value=" + this.value + ")";
        }
    }
}

