/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.VkeyWitness;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import java.util.ArrayList;
import java.util.List;

public class TransactionWitnessSet {
    private List<VkeyWitness> vkeyWitnesses = new ArrayList<VkeyWitness>();
    private List<NativeScript> nativeScripts = new ArrayList<NativeScript>();

    public Map serialize() throws CborSerializationException {
        Map witnessMap = new Map();
        if (this.vkeyWitnesses != null && this.vkeyWitnesses.size() > 0) {
            Array vkeyWitnessArray = new Array();
            for (VkeyWitness vkeyWitness : this.vkeyWitnesses) {
                vkeyWitnessArray.add((DataItem)vkeyWitness.serialize());
            }
            witnessMap.put((DataItem)new UnsignedInteger(0L), (DataItem)vkeyWitnessArray);
        }
        if (this.nativeScripts != null && this.nativeScripts.size() > 0) {
            Array nativeScriptArray = new Array();
            for (NativeScript nativeScript : this.nativeScripts) {
                nativeScriptArray.add(nativeScript.serializeAsDataItem());
            }
            witnessMap.put((DataItem)new UnsignedInteger(1L), (DataItem)nativeScriptArray);
        }
        return witnessMap;
    }

    public static TransactionWitnessSet deserialize(Map witnessMap) throws CborDeserializationException {
        TransactionWitnessSet transactionWitnessSet = new TransactionWitnessSet();
        DataItem vkWitnessesArray = witnessMap.get((DataItem)new UnsignedInteger(0L));
        DataItem nativeScriptArray = witnessMap.get((DataItem)new UnsignedInteger(1L));
        if (vkWitnessesArray != null) {
            List vkeyWitnessesDIList = ((Array)vkWitnessesArray).getDataItems();
            ArrayList<VkeyWitness> vkeyWitnesses = new ArrayList<VkeyWitness>();
            for (DataItem vkWitness : vkeyWitnessesDIList) {
                VkeyWitness vkeyWitness = VkeyWitness.deserialize((Array)vkWitness);
                vkeyWitnesses.add(vkeyWitness);
            }
            if (vkeyWitnesses.size() > 0) {
                transactionWitnessSet.setVkeyWitnesses(vkeyWitnesses);
            }
        } else {
            transactionWitnessSet.setVkeyWitnesses(null);
        }
        if (nativeScriptArray != null) {
            List nativeScriptsDIList = ((Array)nativeScriptArray).getDataItems();
            ArrayList<NativeScript> nativeScripts = new ArrayList<NativeScript>();
            for (DataItem nativeScriptDI : nativeScriptsDIList) {
                NativeScript nativeScript = NativeScript.deserialize((Array)nativeScriptDI);
                if (nativeScript == null) continue;
                nativeScripts.add(nativeScript);
            }
            if (nativeScripts.size() > 0) {
                transactionWitnessSet.setNativeScripts(nativeScripts);
            }
        } else {
            transactionWitnessSet.setNativeScripts(null);
        }
        if (transactionWitnessSet.getVkeyWitnesses() == null && transactionWitnessSet.getNativeScripts() == null) {
            return null;
        }
        return transactionWitnessSet;
    }

    public static TransactionWitnessSetBuilder builder() {
        return new TransactionWitnessSetBuilder();
    }

    public List<VkeyWitness> getVkeyWitnesses() {
        return this.vkeyWitnesses;
    }

    public List<NativeScript> getNativeScripts() {
        return this.nativeScripts;
    }

    public void setVkeyWitnesses(List<VkeyWitness> vkeyWitnesses) {
        this.vkeyWitnesses = vkeyWitnesses;
    }

    public void setNativeScripts(List<NativeScript> nativeScripts) {
        this.nativeScripts = nativeScripts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionWitnessSet)) {
            return false;
        }
        TransactionWitnessSet other = (TransactionWitnessSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<VkeyWitness> this$vkeyWitnesses = this.getVkeyWitnesses();
        List<VkeyWitness> other$vkeyWitnesses = other.getVkeyWitnesses();
        if (this$vkeyWitnesses == null ? other$vkeyWitnesses != null : !((Object)this$vkeyWitnesses).equals(other$vkeyWitnesses)) {
            return false;
        }
        List<NativeScript> this$nativeScripts = this.getNativeScripts();
        List<NativeScript> other$nativeScripts = other.getNativeScripts();
        return !(this$nativeScripts == null ? other$nativeScripts != null : !((Object)this$nativeScripts).equals(other$nativeScripts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionWitnessSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<VkeyWitness> $vkeyWitnesses = this.getVkeyWitnesses();
        result = result * 59 + ($vkeyWitnesses == null ? 43 : ((Object)$vkeyWitnesses).hashCode());
        List<NativeScript> $nativeScripts = this.getNativeScripts();
        result = result * 59 + ($nativeScripts == null ? 43 : ((Object)$nativeScripts).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionWitnessSet(vkeyWitnesses=" + this.getVkeyWitnesses() + ", nativeScripts=" + this.getNativeScripts() + ")";
    }

    public TransactionWitnessSet(List<VkeyWitness> vkeyWitnesses, List<NativeScript> nativeScripts) {
        this.vkeyWitnesses = vkeyWitnesses;
        this.nativeScripts = nativeScripts;
    }

    public TransactionWitnessSet() {
    }

    public static class TransactionWitnessSetBuilder {
        private List<VkeyWitness> vkeyWitnesses;
        private List<NativeScript> nativeScripts;

        TransactionWitnessSetBuilder() {
        }

        public TransactionWitnessSetBuilder vkeyWitnesses(List<VkeyWitness> vkeyWitnesses) {
            this.vkeyWitnesses = vkeyWitnesses;
            return this;
        }

        public TransactionWitnessSetBuilder nativeScripts(List<NativeScript> nativeScripts) {
            this.nativeScripts = nativeScripts;
            return this;
        }

        public TransactionWitnessSet build() {
            return new TransactionWitnessSet(this.vkeyWitnesses, this.nativeScripts);
        }

        public String toString() {
            return "TransactionWitnessSet.TransactionWitnessSetBuilder(vkeyWitnesses=" + this.vkeyWitnesses + ", nativeScripts=" + this.nativeScripts + ")";
        }
    }
}

