/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.util.HexUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class Value {
    private BigInteger coin;
    private List<MultiAsset> multiAssets = new ArrayList<MultiAsset>();

    public Map serialize() throws CborSerializationException {
        Map map = new Map();
        if (this.multiAssets != null) {
            for (MultiAsset multiAsset : this.multiAssets) {
                Map assetsMap = new Map();
                for (Asset asset : multiAsset.getAssets()) {
                    ByteString assetNameBytes = new ByteString(asset.getNameAsBytes());
                    UnsignedInteger value = new UnsignedInteger(asset.getValue());
                    assetsMap.put((DataItem)assetNameBytes, (DataItem)value);
                }
                ByteString policyIdByte = new ByteString(HexUtil.decodeHexString(multiAsset.getPolicyId()));
                map.put((DataItem)policyIdByte, (DataItem)assetsMap);
            }
        }
        return map;
    }

    public static Value deserialize(Array valueArray) {
        Value value = new Value();
        List valueDataItems = valueArray.getDataItems();
        if (valueDataItems != null && valueDataItems.size() == 2) {
            UnsignedInteger coinUI = (UnsignedInteger)valueDataItems.get(0);
            BigInteger coin = coinUI.getValue();
            value.setCoin(coin);
            Map multiAssetsMap = (Map)valueDataItems.get(1);
            if (multiAssetsMap != null) {
                for (DataItem key : multiAssetsMap.getKeys()) {
                    MultiAsset multiAsset = MultiAsset.deserialize(multiAssetsMap, key);
                    value.getMultiAssets().add(multiAsset);
                }
            }
        }
        return value;
    }

    public static ValueBuilder builder() {
        return new ValueBuilder();
    }

    public BigInteger getCoin() {
        return this.coin;
    }

    public List<MultiAsset> getMultiAssets() {
        return this.multiAssets;
    }

    public void setCoin(BigInteger coin) {
        this.coin = coin;
    }

    public void setMultiAssets(List<MultiAsset> multiAssets) {
        this.multiAssets = multiAssets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$coin = this.getCoin();
        BigInteger other$coin = other.getCoin();
        if (this$coin == null ? other$coin != null : !((Object)this$coin).equals(other$coin)) {
            return false;
        }
        List<MultiAsset> this$multiAssets = this.getMultiAssets();
        List<MultiAsset> other$multiAssets = other.getMultiAssets();
        return !(this$multiAssets == null ? other$multiAssets != null : !((Object)this$multiAssets).equals(other$multiAssets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Value;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $coin = this.getCoin();
        result = result * 59 + ($coin == null ? 43 : ((Object)$coin).hashCode());
        List<MultiAsset> $multiAssets = this.getMultiAssets();
        result = result * 59 + ($multiAssets == null ? 43 : ((Object)$multiAssets).hashCode());
        return result;
    }

    public String toString() {
        return "Value(coin=" + this.getCoin() + ", multiAssets=" + this.getMultiAssets() + ")";
    }

    public Value(BigInteger coin, List<MultiAsset> multiAssets) {
        this.coin = coin;
        this.multiAssets = multiAssets;
    }

    public Value() {
    }

    public static class ValueBuilder {
        private BigInteger coin;
        private List<MultiAsset> multiAssets;

        ValueBuilder() {
        }

        public ValueBuilder coin(BigInteger coin) {
            this.coin = coin;
            return this;
        }

        public ValueBuilder multiAssets(List<MultiAsset> multiAssets) {
            this.multiAssets = multiAssets;
            return this;
        }

        public Value build() {
            return new Value(this.coin, this.multiAssets);
        }

        public String toString() {
            return "Value.ValueBuilder(coin=" + this.coin + ", multiAssets=" + this.multiAssets + ")";
        }
    }
}

