/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import java.util.Arrays;
import java.util.List;

public class VkeyWitness {
    private byte[] vkey;
    private byte[] signature;

    public Array serialize() {
        Array array = new Array();
        array.add((DataItem)new ByteString(this.vkey));
        array.add((DataItem)new ByteString(this.signature));
        return array;
    }

    public static VkeyWitness deserialize(Array vkWitness) throws CborDeserializationException {
        List dataItemList = vkWitness.getDataItems();
        if (dataItemList == null || dataItemList.size() != 2) {
            throw new CborDeserializationException("VkeyWitness deserialization error. Invalid no of DataItem");
        }
        DataItem vkeyDI = (DataItem)dataItemList.get(0);
        DataItem sigDI = (DataItem)dataItemList.get(1);
        VkeyWitness vkeyWitness = new VkeyWitness();
        vkeyWitness.setVkey(((ByteString)vkeyDI).getBytes());
        vkeyWitness.setSignature(((ByteString)sigDI).getBytes());
        return vkeyWitness;
    }

    public static VkeyWitnessBuilder builder() {
        return new VkeyWitnessBuilder();
    }

    public byte[] getVkey() {
        return this.vkey;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setVkey(byte[] vkey) {
        this.vkey = vkey;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VkeyWitness)) {
            return false;
        }
        VkeyWitness other = (VkeyWitness)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getVkey(), other.getVkey())) {
            return false;
        }
        return Arrays.equals(this.getSignature(), other.getSignature());
    }

    protected boolean canEqual(Object other) {
        return other instanceof VkeyWitness;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getVkey());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        return result;
    }

    public String toString() {
        return "VkeyWitness(vkey=" + Arrays.toString(this.getVkey()) + ", signature=" + Arrays.toString(this.getSignature()) + ")";
    }

    public VkeyWitness(byte[] vkey, byte[] signature) {
        this.vkey = vkey;
        this.signature = signature;
    }

    public VkeyWitness() {
    }

    public static class VkeyWitnessBuilder {
        private byte[] vkey;
        private byte[] signature;

        VkeyWitnessBuilder() {
        }

        public VkeyWitnessBuilder vkey(byte[] vkey) {
            this.vkey = vkey;
            return this;
        }

        public VkeyWitnessBuilder signature(byte[] signature) {
            this.signature = signature;
            return this;
        }

        public VkeyWitness build() {
            return new VkeyWitness(this.vkey, this.signature);
        }

        public String toString() {
            return "VkeyWitness.VkeyWitnessBuilder(vkey=" + Arrays.toString(this.vkey) + ", signature=" + Arrays.toString(this.signature) + ")";
        }
    }
}

