/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.script;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.crypto.KeyGenUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.script.RequireTimeAfter;
import com.bloxbean.cardano.client.transaction.spec.script.RequireTimeBefore;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptAll;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptAny;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptAtLeast;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptPubkey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public interface NativeScript {
    public DataItem serializeAsDataItem() throws CborSerializationException;

    default public byte[] serialize() throws CborSerializationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CborBuilder cborBuilder = new CborBuilder();
        Array array = (Array)this.serializeAsDataItem();
        cborBuilder.add((DataItem)array);
        try {
            new CborEncoder((OutputStream)baos).nonCanonical().encode(cborBuilder.build());
        }
        catch (CborException e) {
            throw new CborSerializationException("Cbor serializaion error", (Exception)((Object)e));
        }
        byte[] encodedBytes = baos.toByteArray();
        return encodedBytes;
    }

    public static NativeScript deserialize(Array nativeScriptArray) throws CborDeserializationException {
        List dataItemList = nativeScriptArray.getDataItems();
        if (dataItemList == null || dataItemList.size() == 0) {
            throw new CborDeserializationException("NativeScript deserialization failed. Invalid no of DataItem");
        }
        int type = ((UnsignedInteger)dataItemList.get(0)).getValue().intValue();
        if (type == 0) {
            return ScriptPubkey.deserialize(nativeScriptArray);
        }
        if (type == 1) {
            return ScriptAll.deserialize(nativeScriptArray);
        }
        if (type == 2) {
            return ScriptAny.deserialize(nativeScriptArray);
        }
        if (type == 3) {
            return ScriptAtLeast.deserialize(nativeScriptArray);
        }
        if (type == 4) {
            return RequireTimeAfter.deserialize(nativeScriptArray);
        }
        if (type == 5) {
            return RequireTimeBefore.deserialize(nativeScriptArray);
        }
        return null;
    }

    @JsonIgnore
    default public String getPolicyId() throws CborSerializationException {
        byte[] first = new byte[]{0};
        byte[] serializedBytes = this.serialize();
        byte[] finalBytes = ByteBuffer.allocate(first.length + serializedBytes.length).put(first).put(serializedBytes).array();
        return Hex.toHexString((byte[])KeyGenUtil.blake2bHash224(finalBytes));
    }
}

