/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.script;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptType;

public class RequireTimeAfter
implements NativeScript {
    private ScriptType type = ScriptType.after;
    private long slot;

    public RequireTimeAfter(long slot) {
        this.slot = slot;
    }

    public RequireTimeAfter after(long slot) {
        this.slot = slot;
        return this;
    }

    @Override
    public DataItem serializeAsDataItem() {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(4L));
        array.add((DataItem)new UnsignedInteger(this.slot));
        return array;
    }

    public static RequireTimeAfter deserialize(Array array) throws CborDeserializationException {
        long slot = ((UnsignedInteger)array.getDataItems().get(1)).getValue().longValue();
        return new RequireTimeAfter(slot);
    }

    public ScriptType getType() {
        return this.type;
    }

    public long getSlot() {
        return this.slot;
    }

    public void setType(ScriptType type) {
        this.type = type;
    }

    public void setSlot(long slot) {
        this.slot = slot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequireTimeAfter)) {
            return false;
        }
        RequireTimeAfter other = (RequireTimeAfter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ScriptType this$type = this.getType();
        ScriptType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequireTimeAfter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $slot = this.getSlot();
        result = result * 59 + (int)($slot >>> 32 ^ $slot);
        ScriptType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "RequireTimeAfter(type=" + (Object)((Object)this.getType()) + ", slot=" + this.getSlot() + ")";
    }
}

