/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.util;

import com.bloxbean.cardano.client.common.Bech32;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Tuple;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class AssetUtil {
    public static Tuple<String, String> getPolicyIdAndAssetName(String asssetId) {
        byte[] bytes = HexUtil.decodeHexString(asssetId);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        byte[] policyId = new byte[28];
        byte[] assetName = new byte[bytes.length - 28];
        bb.get(policyId, 0, policyId.length);
        bb.get(assetName, 0, assetName.length);
        return new Tuple<String, String>(HexUtil.encodeHexString(policyId), HexUtil.encodeHexString(assetName));
    }

    public static String calculateFingerPrint(String policyIdHex, String assetNameHex) {
        String assetId = policyIdHex + assetNameHex;
        byte[] hashBytes = Blake2bUtil.blake2bHash160(HexUtil.decodeHexString(assetId));
        List<Integer> words = AssetUtil.convertBits(hashBytes, 8, 5, false);
        byte[] bytes = new byte[words.size()];
        for (int i = 0; i < words.size(); ++i) {
            bytes[i] = words.get(i).byteValue();
        }
        String hrp = "asset";
        return Bech32.encode(hrp, bytes);
    }

    private static List<Integer> convertBits(byte[] data, int fromWidth, int toWidth, boolean pad) {
        int acc = 0;
        int bits = 0;
        int maxv = (1 << toWidth) - 1;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < data.length; ++i) {
            int value = data[i] & 0xFF;
            if (value < 0 || value >> fromWidth != 0) {
                return null;
            }
            acc = acc << fromWidth | value;
            bits += fromWidth;
            while (bits >= toWidth) {
                ret.add(acc >> (bits -= toWidth) & maxv);
            }
        }
        if (pad) {
            if (bits > 0) {
                ret.add(acc << toWidth - bits & maxv);
            } else if (bits >= fromWidth || (acc << toWidth - bits & maxv) != 0) {
                return null;
            }
        }
        return ret;
    }
}

