/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.account;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressService;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.bip39.MnemonicCode;
import com.bloxbean.cardano.client.crypto.bip39.MnemonicException;
import com.bloxbean.cardano.client.crypto.bip39.Words;
import com.bloxbean.cardano.client.crypto.cip1852.CIP1852;
import com.bloxbean.cardano.client.crypto.cip1852.DerivationPath;
import com.bloxbean.cardano.client.exception.AddressRuntimeException;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.TransactionSigner;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.stream.Collectors;

public class Account {
    @JsonIgnore
    private String mnemonic;
    @JsonIgnore
    private byte[] accountKey;
    private String baseAddress;
    private String changeAddress;
    private String enterpriseAddress;
    private String stakeAddress;
    private Network network;
    @JsonIgnore
    private DerivationPath derivationPath;

    public Account() {
        this(Networks.mainnet(), 0);
    }

    public Account(int index) {
        this(Networks.mainnet(), index);
    }

    public Account(Network network) {
        this(network, 0);
    }

    public Account(Network network, int index) {
        this(network, DerivationPath.createExternalAddressDerivationPath(index), Words.TWENTY_FOUR);
    }

    public Account(Network network, DerivationPath derivationPath, Words noOfWords) {
        this.network = network;
        this.derivationPath = derivationPath;
        this.generateNew(noOfWords);
    }

    public Account(String mnemonic) {
        this(Networks.mainnet(), mnemonic, 0);
    }

    public Account(String mnemonic, int index) {
        this(Networks.mainnet(), mnemonic, index);
    }

    public Account(Network network, String mnemonic) {
        this(network, mnemonic, 0);
    }

    public Account(Network network, String mnemonic, int index) {
        this(network, mnemonic, DerivationPath.createExternalAddressDerivationPath(index));
    }

    public Account(Network network, String mnemonic, DerivationPath derivationPath) {
        this.network = network;
        this.mnemonic = mnemonic;
        this.accountKey = null;
        this.derivationPath = derivationPath;
        this.validateMnemonic();
        this.baseAddress();
    }

    public Account(Network network, byte[] accountKey) {
        this(network, accountKey, 0, 0);
    }

    public Account(Network network, byte[] accountKey, int account, int index) {
        this.network = network;
        this.mnemonic = null;
        if (accountKey.length == 96) {
            this.accountKey = accountKey;
        } else if (accountKey.length == 128) {
            byte[] key = new byte[96];
            System.arraycopy(accountKey, 0, key, 0, 64);
            System.arraycopy(accountKey, 96, key, 64, 32);
        } else {
            throw new RuntimeException("Invalid length (Account Private Key): " + accountKey.length);
        }
        this.derivationPath = DerivationPath.createExternalAddressDerivationPathForAccount(account);
        this.derivationPath.getIndex().setValue(index);
        this.baseAddress();
    }

    public String mnemonic() {
        return this.mnemonic;
    }

    public String baseAddress() {
        if (this.baseAddress == null || this.baseAddress.isEmpty()) {
            HdKeyPair paymentKeyPair = this.getHdKeyPair();
            HdKeyPair stakeKeyPair = this.getStakeKeyPair();
            Address address = AddressService.getInstance().getBaseAddress(paymentKeyPair.getPublicKey(), stakeKeyPair.getPublicKey(), this.network);
            this.baseAddress = address.toBech32();
        }
        return this.baseAddress;
    }

    public String baseAddressAsBase16() {
        if (this.baseAddress == null || this.baseAddress.isEmpty()) {
            this.baseAddress();
        }
        Address address = new Address(this.baseAddress);
        return HexUtil.encodeHexString(address.getBytes());
    }

    public String changeAddress() {
        if (this.changeAddress == null || this.changeAddress.isEmpty()) {
            HdKeyPair changeKeyPair = this.getChangeKeyPair();
            HdKeyPair stakeKeyPair = this.getStakeKeyPair();
            Address address = AddressService.getInstance().getBaseAddress(changeKeyPair.getPublicKey(), stakeKeyPair.getPublicKey(), this.network);
            this.changeAddress = address.toBech32();
        }
        return this.changeAddress;
    }

    public String enterpriseAddress() {
        if (this.enterpriseAddress == null || this.enterpriseAddress.isEmpty()) {
            HdKeyPair paymentKeyPair = this.getHdKeyPair();
            Address address = AddressService.getInstance().getEntAddress(paymentKeyPair.getPublicKey(), this.network);
            this.enterpriseAddress = address.toBech32();
        }
        return this.enterpriseAddress;
    }

    public String stakeAddress() {
        if (this.stakeAddress == null || this.stakeAddress.isEmpty()) {
            HdKeyPair stakeKeyPair = this.getStakeKeyPair();
            Address address = AddressService.getInstance().getRewardAddress(stakeKeyPair.getPublicKey(), this.network);
            this.stakeAddress = address.toBech32();
        }
        return this.stakeAddress;
    }

    @JsonIgnore
    public Address getBaseAddress() {
        if (this.baseAddress == null || this.baseAddress.isEmpty()) {
            this.baseAddress();
        }
        Address address = new Address(this.baseAddress);
        return address;
    }

    @JsonIgnore
    public Address getEnterpriseAddress() {
        if (this.enterpriseAddress == null || this.enterpriseAddress.isEmpty()) {
            this.enterpriseAddress();
        }
        Address address = new Address(this.enterpriseAddress);
        return address;
    }

    @JsonIgnore
    public String getBech32PrivateKey() {
        HdKeyPair hdKeyPair = this.getHdKeyPair();
        return hdKeyPair.getPrivateKey().toBech32();
    }

    @JsonIgnore
    public byte[] privateKeyBytes() {
        HdKeyPair hdKeyPair = this.getHdKeyPair();
        return hdKeyPair.getPrivateKey().getKeyData();
    }

    @JsonIgnore
    public byte[] publicKeyBytes() {
        return this.getHdKeyPair().getPublicKey().getKeyData();
    }

    @JsonIgnore
    public HdKeyPair hdKeyPair() {
        return this.getHdKeyPair();
    }

    @JsonIgnore
    public HdKeyPair stakeHdKeyPair() {
        return this.getStakeKeyPair();
    }

    @JsonIgnore
    public HdKeyPair changeHdKeyPair() {
        return this.getChangeKeyPair();
    }

    @Deprecated
    public String sign(String txnHex) throws CborSerializationException {
        if (txnHex == null || txnHex.length() == 0) {
            throw new CborSerializationException("Invalid transaction hash");
        }
        try {
            Transaction transaction = Transaction.deserialize(HexUtil.decodeHexString(txnHex));
            transaction = this.sign(transaction);
            return transaction.serializeToHex();
        }
        catch (CborDeserializationException e) {
            throw new CborSerializationException("Error in Cbor deserialization", e);
        }
    }

    public Transaction sign(Transaction transaction) {
        return TransactionSigner.INSTANCE.sign(transaction, this.getHdKeyPair());
    }

    public Transaction signWithStakeKey(Transaction transaction) {
        return TransactionSigner.INSTANCE.sign(transaction, this.getStakeKeyPair());
    }

    private void generateNew(Words noOfWords) {
        String mnemonic = null;
        try {
            mnemonic = MnemonicCode.INSTANCE.createMnemonic(noOfWords).stream().collect(Collectors.joining(" "));
        }
        catch (MnemonicException.MnemonicLengthException e) {
            throw new RuntimeException("Mnemonic generation failed", e);
        }
        this.mnemonic = mnemonic;
        this.baseAddress();
    }

    private void validateMnemonic() {
        if (this.mnemonic == null) {
            throw new AddressRuntimeException("Mnemonic cannot be null");
        }
        this.mnemonic = this.mnemonic.replaceAll("\\s+", " ");
        String[] words = this.mnemonic.split("\\s+");
        try {
            MnemonicCode.INSTANCE.check(Arrays.asList(words));
        }
        catch (MnemonicException e) {
            throw new AddressRuntimeException("Invalid mnemonic phrase", e);
        }
    }

    private HdKeyPair getHdKeyPair() {
        HdKeyPair hdKeyPair = this.mnemonic == null || this.mnemonic.trim().length() == 0 ? new CIP1852().getKeyPairFromAccountKey(this.accountKey, this.derivationPath) : new CIP1852().getKeyPairFromMnemonic(this.mnemonic, this.derivationPath);
        return hdKeyPair;
    }

    private HdKeyPair getChangeKeyPair() {
        DerivationPath internalDerivationPath = DerivationPath.createInternalAddressDerivationPathForAccount(this.derivationPath.getAccount().getValue());
        HdKeyPair hdKeyPair = this.mnemonic == null || this.mnemonic.trim().length() == 0 ? new CIP1852().getKeyPairFromAccountKey(this.accountKey, internalDerivationPath) : new CIP1852().getKeyPairFromMnemonic(this.mnemonic, internalDerivationPath);
        return hdKeyPair;
    }

    private HdKeyPair getStakeKeyPair() {
        DerivationPath stakeDerivationPath = DerivationPath.createStakeAddressDerivationPathForAccount(this.derivationPath.getAccount().getValue());
        HdKeyPair hdKeyPair = this.mnemonic == null || this.mnemonic.trim().length() == 0 ? new CIP1852().getKeyPairFromAccountKey(this.accountKey, stakeDerivationPath) : new CIP1852().getKeyPairFromMnemonic(this.mnemonic, stakeDerivationPath);
        return hdKeyPair;
    }

    public String toString() {
        try {
            return this.baseAddress();
        }
        catch (Exception e) {
            return null;
        }
    }
}

