/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.api.helper;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.helper.UtxoTransactionBuilder;
import com.bloxbean.cardano.client.api.helper.impl.UtxoTransactionBuilderImpl;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.crypto.SecretKey;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.transaction.TransactionSigner;
import com.bloxbean.cardano.client.transaction.model.MintTransaction;
import com.bloxbean.cardano.client.transaction.model.PaymentTransaction;
import com.bloxbean.cardano.client.transaction.model.TransactionDetailsParams;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.util.JsonUtil;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBuilder {
    private static final Logger log = LoggerFactory.getLogger(TransactionBuilder.class);
    private UtxoTransactionBuilder utxoTransactionBuilder;
    private ProtocolParamsSupplier protocolParamsSupplier;

    public TransactionBuilder(UtxoSupplier utxoSupplier, ProtocolParamsSupplier protocolParamsSupplier) {
        this.utxoTransactionBuilder = new UtxoTransactionBuilderImpl(utxoSupplier);
        this.protocolParamsSupplier = protocolParamsSupplier;
    }

    public TransactionBuilder(UtxoTransactionBuilder utxoTransactionBuilder, ProtocolParamsSupplier protocolParamsSupplier) {
        this.utxoTransactionBuilder = utxoTransactionBuilder;
        this.protocolParamsSupplier = protocolParamsSupplier;
    }

    public TransactionBuilder(UtxoSelectionStrategy utxoSelectionStrategy, ProtocolParamsSupplier protocolParamsSupplier) {
        this.utxoTransactionBuilder = new UtxoTransactionBuilderImpl(utxoSelectionStrategy);
        this.protocolParamsSupplier = protocolParamsSupplier;
    }

    public UtxoTransactionBuilder getUtxoTransactionBuilder() {
        return this.utxoTransactionBuilder;
    }

    public void setUtxoTransactionBuilder(UtxoTransactionBuilder utxoTransactionBuilder) {
        this.utxoTransactionBuilder = utxoTransactionBuilder;
    }

    public ProtocolParamsSupplier getProtocolParamsSupplier() {
        return this.protocolParamsSupplier;
    }

    public void setProtocolParamsSupplier(ProtocolParamsSupplier protocolParamsSupplier) {
        this.protocolParamsSupplier = protocolParamsSupplier;
    }

    public String createSignedTransaction(List<PaymentTransaction> paymentTransactions, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, AddressExcepion, CborSerializationException {
        if (log.isDebugEnabled()) {
            log.debug("Requests: \n" + JsonUtil.getPrettyJson(paymentTransactions));
        }
        Transaction transaction = this.utxoTransactionBuilder.buildTransaction(paymentTransactions, detailsParams, metadata, this.protocolParamsSupplier.getProtocolParams());
        transaction.setValid(true);
        if (log.isDebugEnabled()) {
            log.debug(JsonUtil.getPrettyJson(transaction));
        }
        Transaction finalTxn = transaction;
        HashSet signers = new HashSet();
        paymentTransactions.forEach(paymentTransaction -> {
            signers.add(paymentTransaction.getSender());
            if (paymentTransaction.getAdditionalWitnessAccounts() != null) {
                signers.addAll(paymentTransaction.getAdditionalWitnessAccounts());
            }
        });
        for (Account signer : signers) {
            finalTxn = signer.sign(finalTxn);
        }
        return finalTxn.serializeToHex();
    }

    public String createSignedMintTransaction(MintTransaction mintTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, AddressExcepion, CborSerializationException {
        if (log.isDebugEnabled()) {
            log.debug("Requests: \n" + JsonUtil.getPrettyJson(mintTransaction));
        }
        Transaction transaction = this.utxoTransactionBuilder.buildMintTokenTransaction(mintTransaction, detailsParams, metadata, this.protocolParamsSupplier.getProtocolParams());
        transaction.setValid(true);
        TransactionWitnessSet transactionWitnessSet = new TransactionWitnessSet();
        transactionWitnessSet.getNativeScripts().add(mintTransaction.getPolicy().getPolicyScript());
        transaction.setWitnessSet(transactionWitnessSet);
        if (log.isDebugEnabled()) {
            log.debug(JsonUtil.getPrettyJson(transaction));
        }
        Transaction signedTxn = mintTransaction.getSender().sign(transaction);
        if (mintTransaction.getPolicy().getPolicyKeys() != null) {
            for (SecretKey key : mintTransaction.getPolicy().getPolicyKeys()) {
                signedTxn = TransactionSigner.INSTANCE.sign(signedTxn, key);
            }
        }
        if (mintTransaction.getAdditionalWitnessAccounts() != null) {
            for (Account addWitnessAcc : mintTransaction.getAdditionalWitnessAccounts()) {
                signedTxn = addWitnessAcc.sign(signedTxn);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(signedTxn.toString());
            log.debug(signedTxn.serializeToHex());
        }
        return signedTxn.serializeToHex();
    }
}

