/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.api.helper;

import com.bloxbean.cardano.client.api.TransactionProcessor;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.helper.TransactionBuilder;
import com.bloxbean.cardano.client.api.helper.model.TransactionResult;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.transaction.model.MintTransaction;
import com.bloxbean.cardano.client.transaction.model.PaymentTransaction;
import com.bloxbean.cardano.client.transaction.model.TransactionDetailsParams;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHelperService {
    private static final Logger log = LoggerFactory.getLogger(TransactionHelperService.class);
    private TransactionProcessor transactionProcessor;
    private TransactionBuilder transactionBuilder;

    public TransactionHelperService(TransactionBuilder transactionBuilder, TransactionProcessor transactionProcessor) {
        this.transactionProcessor = transactionProcessor;
        this.transactionBuilder = transactionBuilder;
    }

    public Result<TransactionResult> transfer(PaymentTransaction paymentTransaction, TransactionDetailsParams detailsParams) throws ApiException, AddressExcepion, CborSerializationException {
        return this.transfer(Arrays.asList(paymentTransaction), detailsParams, null);
    }

    public Result<TransactionResult> transfer(PaymentTransaction paymentTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, AddressExcepion, CborSerializationException {
        return this.transfer(Arrays.asList(paymentTransaction), detailsParams, metadata);
    }

    public Result<TransactionResult> transfer(List<PaymentTransaction> paymentTransactions, TransactionDetailsParams detailsParams) throws ApiException, AddressExcepion, CborSerializationException {
        return this.transfer(paymentTransactions, detailsParams, null);
    }

    public Result<TransactionResult> transfer(List<PaymentTransaction> paymentTransactions, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, AddressExcepion, CborSerializationException {
        String signedTxn = this.transactionBuilder.createSignedTransaction(paymentTransactions, detailsParams, metadata);
        byte[] signedTxnBytes = HexUtil.decodeHexString(signedTxn);
        Result<String> result = this.transactionProcessor.submitTransaction(signedTxnBytes);
        if (!result.isSuccessful()) {
            log.error("Trasaction submission failed");
        }
        return this.processTransactionResult(signedTxnBytes, result);
    }

    public Result<TransactionResult> mintToken(MintTransaction mintTransaction, TransactionDetailsParams detailsParams) throws AddressExcepion, ApiException, CborSerializationException {
        return this.mintToken(mintTransaction, detailsParams, null);
    }

    public Result<TransactionResult> mintToken(MintTransaction mintTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws AddressExcepion, ApiException, CborSerializationException {
        String signedTxn = this.transactionBuilder.createSignedMintTransaction(mintTransaction, detailsParams, metadata);
        byte[] signedTxnBytes = HexUtil.decodeHexString(signedTxn);
        Result<String> result = this.transactionProcessor.submitTransaction(signedTxnBytes);
        return this.processTransactionResult(signedTxnBytes, result);
    }

    public TransactionBuilder getTransactionBuilder() {
        return this.transactionBuilder;
    }

    public void setTransactionBuilder(TransactionBuilder transactionBuilder) {
        this.transactionBuilder = transactionBuilder;
    }

    private Result<TransactionResult> processTransactionResult(byte[] signedTxn, Result<String> result) {
        TransactionResult transactionResult = new TransactionResult();
        transactionResult.setSignedTxn(signedTxn);
        if (result.isSuccessful()) {
            transactionResult.setTransactionId(result.getValue());
            return Result.success(result.getResponse()).withValue(transactionResult).code(result.code());
        }
        transactionResult.setTransactionId(null);
        return Result.error(result.getResponse()).withValue(transactionResult).code(result.code());
    }
}

