/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.api.helper.impl;

import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.InsufficientBalanceException;
import com.bloxbean.cardano.client.api.helper.FeeCalculationService;
import com.bloxbean.cardano.client.api.helper.TransactionBuilder;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.transaction.model.MintTransaction;
import com.bloxbean.cardano.client.transaction.model.PaymentTransaction;
import com.bloxbean.cardano.client.transaction.model.TransactionDetailsParams;
import com.bloxbean.cardano.client.transaction.spec.ExUnits;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.util.HexUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FeeCalculationServiceImpl
implements FeeCalculationService {
    private static final BigInteger DUMMY_FEE = BigInteger.valueOf(170000L);
    private static final BigInteger MIN_DUMMY_FEE = BigInteger.valueOf(100000L);
    private TransactionBuilder transactionBuilder;
    private ProtocolParamsSupplier protocolParamsSupplier;

    public FeeCalculationServiceImpl(UtxoSupplier utxoSupplier, ProtocolParamsSupplier protocolParamsSupplier) {
        this.transactionBuilder = new TransactionBuilder(utxoSupplier, protocolParamsSupplier);
        this.protocolParamsSupplier = protocolParamsSupplier;
    }

    public FeeCalculationServiceImpl(TransactionBuilder transactionBuilder) {
        this.transactionBuilder = transactionBuilder;
        this.protocolParamsSupplier = transactionBuilder.getProtocolParamsSupplier();
    }

    @Override
    public BigInteger calculateFee(PaymentTransaction paymentTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, CborSerializationException, AddressExcepion {
        ProtocolParams protocolParams = this.protocolParamsSupplier.getProtocolParams();
        if (protocolParams == null) {
            throw new ApiException("Unable to fetch protocol parameters to calculate the fee");
        }
        return this.calculateFee(paymentTransaction, detailsParams, metadata, protocolParams);
    }

    @Override
    public BigInteger calculateFee(PaymentTransaction paymentTransaction, TransactionDetailsParams detailsParams, Metadata metadata, ProtocolParams protocolParams) throws CborSerializationException, AddressExcepion, ApiException {
        String txnCBORHash;
        PaymentTransaction clonePaymentTransaction = paymentTransaction.toBuilder().build();
        if (clonePaymentTransaction.getFee() == null || clonePaymentTransaction.getFee().compareTo(DUMMY_FEE) == -1) {
            clonePaymentTransaction.setFee(DUMMY_FEE);
        }
        try {
            txnCBORHash = this.transactionBuilder.createSignedTransaction(Arrays.asList(clonePaymentTransaction), detailsParams, metadata);
        }
        catch (InsufficientBalanceException e) {
            if ("lovelace".equals(clonePaymentTransaction.getUnit())) {
                clonePaymentTransaction.setFee(MIN_DUMMY_FEE);
                clonePaymentTransaction.setAmount(clonePaymentTransaction.getAmount().subtract(MIN_DUMMY_FEE));
                txnCBORHash = this.transactionBuilder.createSignedTransaction(Arrays.asList(clonePaymentTransaction), detailsParams, metadata);
            }
            throw e;
        }
        return this.doFeeCalculationFromTxnSize(HexUtil.decodeHexString(txnCBORHash), protocolParams);
    }

    @Override
    public BigInteger calculateFee(MintTransaction mintTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, CborSerializationException, AddressExcepion {
        ProtocolParams protocolParams = this.protocolParamsSupplier.getProtocolParams();
        if (protocolParams == null) {
            throw new ApiException("Unable to fetch protocol parameters to calculate the fee");
        }
        return this.calculateFee(mintTransaction, detailsParams, metadata, protocolParams);
    }

    @Override
    public BigInteger calculateFee(MintTransaction mintTransaction, TransactionDetailsParams detailsParams, Metadata metadata, ProtocolParams protocolParams) throws ApiException, CborSerializationException, AddressExcepion {
        if (mintTransaction.getFee() == null || mintTransaction.getFee().compareTo(DUMMY_FEE) == -1) {
            mintTransaction.setFee(DUMMY_FEE);
        }
        String txnCBORHash = this.transactionBuilder.createSignedMintTransaction(mintTransaction, detailsParams, metadata);
        return this.doFeeCalculationFromTxnSize(HexUtil.decodeHexString(txnCBORHash), protocolParams);
    }

    @Override
    public BigInteger calculateFee(Transaction transaction) throws ApiException, CborSerializationException {
        ProtocolParams protocolParams = this.protocolParamsSupplier.getProtocolParams();
        if (protocolParams == null) {
            throw new ApiException("Unable to fetch protocol parameters to calculate the fee");
        }
        return this.calculateFee(transaction, protocolParams);
    }

    @Override
    public BigInteger calculateFee(Transaction transaction, ProtocolParams protocolParams) throws CborSerializationException {
        if (transaction.getBody().getFee() == null) {
            transaction.getBody().setFee(DUMMY_FEE);
        }
        byte[] serializedBytes = transaction.serialize();
        return this.doFeeCalculationFromTxnSize(serializedBytes, protocolParams);
    }

    @Override
    public BigInteger calculateFee(byte[] transaction) throws ApiException {
        ProtocolParams protocolParams = this.protocolParamsSupplier.getProtocolParams();
        if (protocolParams == null) {
            throw new ApiException("Unable to fetch protocol parameters to calculate the fee");
        }
        return this.calculateFee(transaction, protocolParams);
    }

    @Override
    public BigInteger calculateFee(byte[] transaction, ProtocolParams protocolParams) {
        return this.doFeeCalculationFromTxnSize(transaction, protocolParams);
    }

    @Override
    public BigInteger calculateFee(List<PaymentTransaction> paymentTransactions, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, CborSerializationException, AddressExcepion {
        ProtocolParams protocolParams = this.protocolParamsSupplier.getProtocolParams();
        if (protocolParams == null) {
            throw new ApiException("Unable to fetch protocol parameters to calculate the fee");
        }
        return this.calculateFee(paymentTransactions, detailsParams, metadata, protocolParams);
    }

    @Override
    public BigInteger calculateFee(List<PaymentTransaction> paymentTransactions, TransactionDetailsParams detailsParams, Metadata metadata, ProtocolParams protocolParams) throws CborSerializationException, AddressExcepion, ApiException {
        String txnCBORHash;
        List<PaymentTransaction> clonePaymentTransactions = paymentTransactions.stream().map(paymentTransaction -> paymentTransaction.toBuilder().build()).collect(Collectors.toList());
        ((PaymentTransaction)clonePaymentTransactions.get(0)).setFee(DUMMY_FEE);
        clonePaymentTransactions.stream().skip(1L).forEach(paymentTransaction -> paymentTransaction.setFee(null));
        try {
            txnCBORHash = this.transactionBuilder.createSignedTransaction(clonePaymentTransactions, detailsParams, metadata);
        }
        catch (InsufficientBalanceException exception) {
            ((PaymentTransaction)clonePaymentTransactions.get(0)).setFee(MIN_DUMMY_FEE);
            clonePaymentTransactions.stream().filter(paymentTransaction -> paymentTransaction.getUnit().equals("lovelace")).findFirst().ifPresent(paymentTransaction -> paymentTransaction.setAmount(paymentTransaction.getAmount().subtract(MIN_DUMMY_FEE)));
            txnCBORHash = this.transactionBuilder.createSignedTransaction(clonePaymentTransactions, detailsParams, metadata);
        }
        return this.doFeeCalculationFromTxnSize(HexUtil.decodeHexString(txnCBORHash), protocolParams);
    }

    @Override
    public BigInteger calculateScriptFee(List<ExUnits> exUnitsList) throws ApiException {
        ProtocolParams protocolParams = this.protocolParamsSupplier.getProtocolParams();
        if (protocolParams == null) {
            throw new ApiException("Unable to fetch protocol parameters to calculate the fee");
        }
        return this.calculateScriptFee(exUnitsList, protocolParams);
    }

    @Override
    public BigInteger calculateScriptFee(List<ExUnits> exUnitsList, ProtocolParams protocolParams) {
        BigDecimal priceMem = protocolParams.getPriceMem();
        BigDecimal priceSteps = protocolParams.getPriceStep();
        BigDecimal scriptFee = BigDecimal.ZERO;
        for (ExUnits exUnits : exUnitsList) {
            BigDecimal memCost = new BigDecimal(exUnits.getMem()).multiply(priceMem);
            BigDecimal stepCost = new BigDecimal(exUnits.getSteps()).multiply(priceSteps);
            scriptFee = scriptFee.add(memCost.add(stepCost));
        }
        scriptFee = scriptFee.setScale(0, RoundingMode.CEILING);
        return scriptFee.toBigInteger();
    }

    private BigInteger doFeeCalculationFromTxnSize(byte[] bytes, ProtocolParams protocolParams) {
        return BigInteger.valueOf(protocolParams.getMinFeeA() * bytes.length + protocolParams.getMinFeeB());
    }
}

