/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.api.helper.impl;

import com.bloxbean.cardano.client.api.exception.InsufficientBalanceException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.common.MinAdaCalculator;
import com.bloxbean.cardano.client.transaction.model.MintTransaction;
import com.bloxbean.cardano.client.transaction.model.PaymentTransaction;
import com.bloxbean.cardano.client.transaction.model.TransactionDetailsParams;
import com.bloxbean.cardano.client.transaction.model.TransactionRequest;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.TransactionBody;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.AssetUtil;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Triple;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtxoTransactionBodyBuilder {
    private static final Logger log = LoggerFactory.getLogger(UtxoTransactionBodyBuilder.class);

    public static TransactionBody buildMintBody(MintTransaction request, TransactionDetailsParams detailsParams, ProtocolParams protocolParams, UtxoSelectionStrategy selectionStrategy) {
        HashSet<Utxo> utxos;
        String sender = request.getSender().baseAddress();
        String receiver = request.getReceiver();
        if (receiver == null) {
            receiver = sender;
        }
        BigInteger minBaseAmount = new MinAdaCalculator(protocolParams).calculateMinAda(request.getMintAssets());
        BigInteger totalCost = minBaseAmount.add(request.getFee());
        HashSet<Utxo> hashSet = utxos = request.getUtxosToInclude() != null ? new HashSet<Utxo>(request.getUtxosToInclude()) : new HashSet();
        if (utxos.isEmpty()) {
            utxos.addAll(selectionStrategy.select(sender, new Amount("lovelace", totalCost), Collections.emptySet()));
        }
        if (utxos.isEmpty()) {
            throw new InsufficientBalanceException("Not enough utxos found to cover mint balance: " + totalCost + " lovelace");
        }
        ArrayList<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
        ArrayList<TransactionOutput> transactionOutputs = new ArrayList<TransactionOutput>();
        for (Utxo utxo : utxos) {
            TransactionInput transactionInput = new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex());
            transactionInputs.add(transactionInput);
        }
        CalculatedChangeTransactions calculatedChangeTransactions = UtxoTransactionBodyBuilder.calculateChangeTransactions(sender, Collections.singletonList(new Amount("lovelace", BigInteger.ZERO)), utxos, totalCost, protocolParams, selectionStrategy);
        transactionOutputs.addAll(calculatedChangeTransactions.getTransactionOutputs());
        transactionInputs.addAll(calculatedChangeTransactions.getTransactionInputs());
        utxos.addAll(calculatedChangeTransactions.getAdditionalUtxos());
        TransactionOutput mintedTransactionOutput = new TransactionOutput(receiver, new Value(minBaseAmount, request.getMintAssets()));
        mintedTransactionOutput.setDatumHash(request.getDatumHash() != null ? HexUtil.decodeHexString(request.getDatumHash()) : null);
        transactionOutputs.add(mintedTransactionOutput);
        return new TransactionBody(transactionInputs, transactionOutputs, request.getFee(), detailsParams != null ? detailsParams.getTtl() : 0L, null, null, null, null, detailsParams != null ? detailsParams.getValidityStartInterval() : 0L, request.getMintAssets(), null, null, null, detailsParams != null ? detailsParams.getNetworkId() : null, null, null, null);
    }

    public static TransactionBody buildTransferBody(List<PaymentTransaction> requests, TransactionDetailsParams detailParams, ProtocolParams protocolParams, UtxoSelectionStrategy selectionStrategy) {
        CalculatedOutputs calculatedOutputs = UtxoTransactionBodyBuilder.calculateOutputs(requests, protocolParams);
        Map<String, List<Amount>> requestedAmountPerSender = UtxoTransactionBodyBuilder.getRequestedAmountPerSender(requests);
        Map<String, Set<Utxo>> utxosPerSender = UtxoTransactionBodyBuilder.getUtxosPerSenderFromRequests(requests);
        if (utxosPerSender.isEmpty()) {
            Map<String, BigInteger> costPerSender = calculatedOutputs.getMiscCostPerSender();
            Map<String, List<Amount>> requestedAmountPerSenderIncludingCost = UtxoTransactionBodyBuilder.mergeCosts(costPerSender, requestedAmountPerSender);
            utxosPerSender.putAll(UtxoTransactionBodyBuilder.getUtxosPerSender(requestedAmountPerSenderIncludingCost, selectionStrategy));
        }
        for (String sender : calculatedOutputs.getMiscCostPerSender().keySet()) {
            BigInteger minCost = calculatedOutputs.getMiscCostPerSender().get(sender);
            Set utxos = utxosPerSender.computeIfAbsent(sender, key -> new HashSet());
            Set<Utxo> additionalUtxos = UtxoTransactionBodyBuilder.calculateAdditionalUtxos(sender, minCost, utxos, selectionStrategy);
            utxos.addAll(additionalUtxos);
        }
        ArrayList<TransactionOutput> transactionOutputs = new ArrayList<TransactionOutput>(calculatedOutputs.getTransactionOutputs());
        ArrayList<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
        for (Map.Entry<String, Set<Utxo>> entry : utxosPerSender.entrySet()) {
            String sender = entry.getKey();
            Set<Utxo> usedUtxos = entry.getValue();
            for (Utxo utxo : usedUtxos) {
                TransactionInput transactionInput = new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex());
                transactionInputs.add(transactionInput);
            }
            CalculatedChangeTransactions calculatedChangeTransactions = UtxoTransactionBodyBuilder.calculateChangeTransactions(sender, requestedAmountPerSender.get(sender), usedUtxos, calculatedOutputs.getMiscCostPerSender().get(sender), protocolParams, selectionStrategy);
            transactionOutputs.addAll(calculatedChangeTransactions.getTransactionOutputs());
            transactionInputs.addAll(calculatedChangeTransactions.getTransactionInputs());
            usedUtxos.addAll(calculatedChangeTransactions.getAdditionalUtxos());
        }
        return new TransactionBody(transactionInputs, transactionOutputs, calculatedOutputs.getTotalFee(), detailParams != null ? detailParams.getTtl() : 0L, null, null, null, null, detailParams != null ? detailParams.getValidityStartInterval() : 0L, null, null, null, null, detailParams != null ? detailParams.getNetworkId() : null, null, null, null);
    }

    private static Map<String, List<Amount>> mergeCosts(Map<String, BigInteger> costPerSender, Map<String, List<Amount>> requestedAmountPerSender) {
        if (costPerSender == null || costPerSender.isEmpty()) {
            return requestedAmountPerSender;
        }
        if (requestedAmountPerSender == null || requestedAmountPerSender.isEmpty()) {
            return costPerSender.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<String, List<Amount>>((String)entry.getKey(), Collections.singletonList(new Amount("lovelace", (BigInteger)entry.getValue())))).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
        }
        return Stream.concat(requestedAmountPerSender.entrySet().stream(), costPerSender.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<String, List<Amount>>((String)entry.getKey(), Collections.singletonList(new Amount("lovelace", (BigInteger)entry.getValue()))))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.flatMapping(entry -> ((List)entry.getValue()).stream(), Collectors.toList()))).entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry((String)entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.groupingBy(Amount::getUnit, Collectors.reducing(BigInteger.ZERO, Amount::getQuantity, BigInteger::add))).entrySet().stream().map(val -> new Amount((String)val.getKey(), (BigInteger)val.getValue())).collect(Collectors.toList()))).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
    }

    private static OutputAmount initChangeAmount(List<Amount> requestedAmounts) {
        BigInteger baseAmount = requestedAmounts.stream().filter(amount -> "lovelace".equals(amount.getUnit())).map(amount -> amount.getQuantity()).reduce(BigInteger.ZERO, BigInteger::subtract);
        List<MultiAsset> multiAssets = requestedAmounts.stream().filter(amount -> !"lovelace".equals(amount.getUnit())).map(amount -> new Tuple<Tuple<String, String>, BigInteger>(AssetUtil.getPolicyIdAndAssetName(amount.getUnit()), amount.getQuantity())).collect(Collectors.groupingBy(tuple -> (String)((Tuple)tuple._1)._1, Collectors.groupingBy(tuple -> (String)((Tuple)tuple._1)._2, Collectors.reducing(BigInteger.ZERO, tuple -> (BigInteger)tuple._2, BigInteger::add)))).entrySet().stream().map(entry -> new MultiAsset((String)entry.getKey(), ((Map)entry.getValue()).entrySet().stream().map(valueEntry -> new Asset((String)valueEntry.getKey(), ((BigInteger)valueEntry.getValue()).negate())).collect(Collectors.toList()))).collect(Collectors.toList());
        return new OutputAmount(baseAmount, multiAssets);
    }

    private static Asset toAsset(Amount amount) {
        return amount != null ? new Asset((String)AssetUtil.getPolicyIdAndAssetName((String)amount.getUnit())._2, amount.getQuantity()) : null;
    }

    private static OutputAmount applyUtxoToChangeAmount(OutputAmount outputAmount, Set<Utxo> utxos) {
        BigInteger baseAmount = outputAmount.getBaseAmount();
        List<MultiAsset> multiAssets = outputAmount.getMultiAssets();
        for (Utxo utxo : utxos) {
            for (Amount utxoAmt : utxo.getAmount()) {
                String utxoUnit = utxoAmt.getUnit();
                BigInteger utxoQty = utxoAmt.getQuantity();
                if (utxoUnit.equals("lovelace")) {
                    baseAmount = baseAmount.add(utxoQty);
                    continue;
                }
                Tuple<String, String> policyIdAssetName = AssetUtil.getPolicyIdAndAssetName(utxoUnit);
                ArrayList<MultiAsset> currentMultiAssets = new ArrayList<MultiAsset>(multiAssets);
                Optional<MultiAsset> matchingMultiAsset = multiAssets.stream().filter(ma -> ((String)policyIdAssetName._1).equals(ma.getPolicyId())).findFirst();
                if (matchingMultiAsset.isPresent()) {
                    ArrayList<Asset> assetAmountsForPolicy = new ArrayList<Asset>(matchingMultiAsset.get().getAssets());
                    Optional<Asset> matchingAsset = matchingMultiAsset.get().getAssets().stream().filter(assetAmount -> ((String)policyIdAssetName._2).equals(assetAmount.getName())).findFirst();
                    if (matchingAsset.isPresent()) {
                        assetAmountsForPolicy.remove(matchingAsset.get());
                        assetAmountsForPolicy.add(matchingAsset.get().plus(UtxoTransactionBodyBuilder.toAsset(utxoAmt)));
                    } else {
                        assetAmountsForPolicy.add(new Asset((String)policyIdAssetName._2, utxoQty));
                    }
                    currentMultiAssets.remove(matchingMultiAsset.get());
                    currentMultiAssets.add(new MultiAsset(matchingMultiAsset.get().getPolicyId(), assetAmountsForPolicy));
                    multiAssets.clear();
                    multiAssets.addAll(currentMultiAssets);
                    continue;
                }
                multiAssets.add(AssetUtil.getMultiAssetFromUnitAndAmount(utxoUnit, utxoQty));
            }
            multiAssets = multiAssets.stream().map(assets -> new MultiAsset(assets.getPolicyId(), assets.getAssets() != null ? assets.getAssets().stream().filter(asset -> asset.getValue() != null && !BigInteger.ZERO.equals(asset.getValue())).collect(Collectors.toList()) : Collections.emptyList())).filter(assets -> assets.getAssets() != null && !assets.getAssets().isEmpty()).collect(Collectors.toList());
        }
        return new OutputAmount(baseAmount, multiAssets);
    }

    private static CalculatedChangeTransactions calculateChangeTransactions(String sender, List<Amount> requestedAmounts, Set<Utxo> usedUtxos, BigInteger miscCost, ProtocolParams protocolParams, UtxoSelectionStrategy selectionStrategy) {
        ArrayList<TransactionOutput> transactionOutputs = new ArrayList<TransactionOutput>();
        ArrayList<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
        ArrayList<Utxo> additionalUtxos = new ArrayList<Utxo>();
        usedUtxos = new HashSet<Utxo>(usedUtxos);
        OutputAmount changeAmount = UtxoTransactionBodyBuilder.initChangeAmount(requestedAmounts);
        if ((changeAmount = UtxoTransactionBodyBuilder.applyUtxoToChangeAmount(changeAmount, usedUtxos)).getBaseAmount().compareTo(BigInteger.ZERO) > 0 || !changeAmount.getMultiAssets().isEmpty()) {
            if ((changeAmount = new OutputAmount(changeAmount.getBaseAmount().subtract(miscCost), changeAmount.getMultiAssets())).getBaseAmount().compareTo(BigInteger.ZERO) != 0 || !changeAmount.getMultiAssets().isEmpty()) {
                BigInteger minRequiredLovelaceInOutput = new MinAdaCalculator(protocolParams).calculateMinAda(new TransactionOutput(sender, new Value(changeAmount.getBaseAmount(), changeAmount.getMultiAssets())));
                while (minRequiredLovelaceInOutput.compareTo(changeAmount.getBaseAmount()) > 0) {
                    HashSet<Utxo> allUsedUtxos = new HashSet<Utxo>(usedUtxos);
                    allUsedUtxos.addAll(additionalUtxos);
                    Set<Utxo> newUtxos = UtxoTransactionBodyBuilder.calculateUtxos(sender, Collections.singletonList(new Amount("lovelace", minRequiredLovelaceInOutput.subtract(changeAmount.getBaseAmount()))), allUsedUtxos, selectionStrategy);
                    if (newUtxos.isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.warn("Not enough utxos found to cover minimum lovelace in an output");
                        }
                        throw new InsufficientBalanceException("Not enough utxos found to cover minimum lovelace in an output");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Additional Utoxs found: " + newUtxos);
                    }
                    for (Utxo addUtxo : newUtxos) {
                        TransactionInput addTxnInput = new TransactionInput(addUtxo.getTxHash(), addUtxo.getOutputIndex());
                        transactionInputs.add(addTxnInput);
                    }
                    changeAmount = UtxoTransactionBodyBuilder.applyUtxoToChangeAmount(changeAmount, newUtxos);
                    additionalUtxos.addAll(newUtxos);
                    minRequiredLovelaceInOutput = new MinAdaCalculator(protocolParams).calculateMinAda(new TransactionOutput(sender, new Value(changeAmount.getBaseAmount(), changeAmount.getMultiAssets())));
                }
            }
            if (BigInteger.ZERO.compareTo(changeAmount.getBaseAmount()) < 0 || !changeAmount.getMultiAssets().isEmpty()) {
                transactionOutputs.add(new TransactionOutput(sender, new Value(changeAmount.getBaseAmount(), changeAmount.getMultiAssets())));
            }
            if (BigInteger.ZERO.compareTo(changeAmount.getBaseAmount()) == 0 && !changeAmount.getMultiAssets().isEmpty()) {
                log.warn("The sender address balance cannot be zero as the sender has {} native token(s).", (Object)changeAmount.getMultiAssets().size());
            }
        }
        return new CalculatedChangeTransactions(transactionInputs, transactionOutputs, additionalUtxos);
    }

    private static Set<Utxo> calculateAdditionalUtxos(String sender, BigInteger required, Set<Utxo> currentUtxos, UtxoSelectionStrategy selectionStrategy) {
        BigInteger totalLoveLace = currentUtxos.stream().flatMap(utxo -> utxo.getAmount().stream()).filter(amt -> "lovelace".equals(amt.getUnit())).map(Amount::getQuantity).reduce(BigInteger.ZERO, BigInteger::add);
        if (required != null && totalLoveLace.compareTo(required) < 0) {
            BigInteger additionalAmt = required.subtract(totalLoveLace).add(BigInteger.ONE);
            return UtxoTransactionBodyBuilder.calculateUtxos(sender, Collections.singletonList(new Amount("lovelace", additionalAmt)), currentUtxos, selectionStrategy);
        }
        return Collections.emptySet();
    }

    private static Set<Utxo> calculateUtxos(String sender, List<Amount> required, Set<Utxo> currentUtxos, UtxoSelectionStrategy selectionStrategy) {
        Set<Utxo> newUtxos = selectionStrategy.select(sender, required, currentUtxos);
        if (newUtxos == null || newUtxos.isEmpty()) {
            throw new InsufficientBalanceException(String.format("No utxos found for address for additional amount: %s, unit: %s, amount: %s", sender, "lovelace", required));
        }
        return newUtxos;
    }

    private static boolean isEqualString(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private static OutputAmount groupRequestedOutput(List<PaymentTransaction> requests) {
        BigInteger baseAmount = BigInteger.ZERO;
        ArrayList<MultiAsset> multiAssets = new ArrayList<MultiAsset>();
        for (PaymentTransaction transaction : requests) {
            if ("lovelace".equals(transaction.getUnit())) {
                baseAmount = baseAmount.add(transaction.getAmount());
                continue;
            }
            Tuple<String, String> policyIdAssetName = AssetUtil.getPolicyIdAndAssetName(transaction.getUnit());
            Amount asset = new Amount((String)policyIdAssetName._2, transaction.getAmount());
            Optional<MultiAsset> existingMultiAsset = multiAssets.stream().filter(ma -> UtxoTransactionBodyBuilder.isEqualString(ma.getPolicyId(), (String)policyIdAssetName._1)).findFirst();
            if (existingMultiAsset.isPresent()) {
                ArrayList<Asset> allAssetsInMulti = new ArrayList<Asset>(existingMultiAsset.get().getAssets());
                Optional<Asset> existingAmount = allAssetsInMulti.stream().filter(assetAmount -> UtxoTransactionBodyBuilder.isEqualString(assetAmount.getName(), asset.getUnit())).findFirst();
                if (existingAmount.isPresent()) {
                    allAssetsInMulti.remove(existingAmount.get());
                    allAssetsInMulti.add(UtxoTransactionBodyBuilder.toAsset(new Amount(asset.getUnit(), existingAmount.get().getValue() != null ? existingAmount.get().getValue().add(asset.getQuantity()) : asset.getQuantity())));
                } else {
                    allAssetsInMulti.add(UtxoTransactionBodyBuilder.toAsset(asset));
                }
                multiAssets.remove(existingMultiAsset.get());
                multiAssets.add(new MultiAsset((String)policyIdAssetName._1, allAssetsInMulti));
                continue;
            }
            multiAssets.add(AssetUtil.getMultiAssetFromUnitAndAmount(transaction.getUnit(), transaction.getAmount()));
        }
        return new OutputAmount(baseAmount, multiAssets);
    }

    private static TransactionOutput calculateOutputForGroup(PaymentTransactionGroupingKey groupingKey, List<PaymentTransaction> requests, OutputAmount groupedOutputAmount, ProtocolParams protocolParams) {
        BigInteger minRequiredAda = new MinAdaCalculator(protocolParams).calculateMinAda(new TransactionOutput(groupingKey.getReceiver(), new Value(groupedOutputAmount.getBaseAmount(), groupedOutputAmount.getMultiAssets())));
        BigInteger actualCoin = minRequiredAda.max(groupedOutputAmount.getBaseAmount());
        OutputAmount outputAmount = new OutputAmount(actualCoin, groupedOutputAmount.getMultiAssets());
        byte[] datumHash = null;
        if (groupingKey.getDatumHash() != null) {
            datumHash = HexUtil.decodeHexString(groupingKey.getDatumHash());
        }
        TransactionOutput output = new TransactionOutput(groupingKey.getReceiver(), new Value(outputAmount.getBaseAmount(), outputAmount.getMultiAssets()));
        output.setDatumHash(datumHash);
        return output;
    }

    private static BigInteger calculateAdditionalCostForGroup(List<PaymentTransaction> requests, OutputAmount groupedOutputAmount, ProtocolParams protocolParams) {
        BigInteger minRequiredAda = new MinAdaCalculator(protocolParams).calculateMinAda(new TransactionOutput(null, new Value(groupedOutputAmount.getBaseAmount(), groupedOutputAmount.getMultiAssets())));
        BigInteger actualCoin = minRequiredAda.max(groupedOutputAmount.getBaseAmount());
        OutputAmount outputAmount = new OutputAmount(actualCoin, groupedOutputAmount.getMultiAssets());
        BigInteger fees = requests.stream().map(TransactionRequest::getFee).filter(Objects::nonNull).reduce(BigInteger.ZERO, BigInteger::add);
        return actualCoin.subtract(groupedOutputAmount.getBaseAmount()).add(fees);
    }

    private static CalculatedOutputs calculateOutputs(List<PaymentTransaction> requests, ProtocolParams protocolParams) {
        List grouped = requests.stream().collect(Collectors.groupingBy(paymentTransaction -> new PaymentTransactionGroupingKey(paymentTransaction.getSender().baseAddress(), paymentTransaction.getReceiver(), paymentTransaction.getDatumHash()))).entrySet().stream().map(entry -> new Triple<PaymentTransactionGroupingKey, List, OutputAmount>((PaymentTransactionGroupingKey)entry.getKey(), (List)entry.getValue(), UtxoTransactionBodyBuilder.groupRequestedOutput((List)entry.getValue()))).collect(Collectors.toList());
        List<TransactionOutput> outputs = grouped.stream().map(triple -> UtxoTransactionBodyBuilder.calculateOutputForGroup((PaymentTransactionGroupingKey)triple._1, (List)triple._2, (OutputAmount)triple._3, protocolParams)).collect(Collectors.toList());
        Map<String, BigInteger> miscCostsPerSender = grouped.stream().map(triple -> new Tuple<String, BigInteger>(((PaymentTransactionGroupingKey)triple._1).getSender(), UtxoTransactionBodyBuilder.calculateAdditionalCostForGroup((List)triple._2, (OutputAmount)triple._3, protocolParams))).collect(Collectors.groupingBy(tuple -> (String)tuple._1, Collectors.reducing(BigInteger.ZERO, tuple -> (BigInteger)tuple._2, BigInteger::add)));
        BigInteger totalFee = requests.stream().filter(request -> request.getFee() != null).map(TransactionRequest::getFee).reduce(BigInteger.ZERO, BigInteger::add);
        return new CalculatedOutputs(miscCostsPerSender, outputs, totalFee);
    }

    private static Map<String, Set<Utxo>> getUtxosPerSender(Map<String, List<Amount>> requestedAmountPerSender, UtxoSelectionStrategy selectionStrategy) {
        return requestedAmountPerSender.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<String, Set<Utxo>>((String)entry.getKey(), selectionStrategy.select((String)entry.getKey(), (List)entry.getValue(), Collections.emptySet()))).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
    }

    private static Map<String, List<Amount>> getRequestedAmountPerSender(List<PaymentTransaction> requests) {
        return requests.stream().collect(Collectors.groupingBy(req -> req.getSender().baseAddress(), Collectors.groupingBy(PaymentTransaction::getUnit, Collectors.reducing(BigInteger.ZERO, PaymentTransaction::getAmount, BigInteger::add)))).entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry((String)entry.getKey(), ((Map)entry.getValue()).entrySet().stream().map(pair -> new Amount((String)pair.getKey(), (BigInteger)pair.getValue())).filter(amount -> amount.getQuantity() != null && amount.getQuantity().compareTo(BigInteger.ZERO) > 0).collect(Collectors.toList()))).filter(entry -> entry.getValue() != null && !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
    }

    private static Map<String, Set<Utxo>> getUtxosPerSenderFromRequests(List<? extends TransactionRequest> transactions) {
        return transactions.stream().filter(tx -> tx.getUtxosToInclude() != null && !tx.getUtxosToInclude().isEmpty()).collect(Collectors.groupingBy(req -> req.getSender().baseAddress())).entrySet().stream().map(entry -> new Tuple((String)entry.getKey(), ((List)entry.getValue()).stream().flatMap(tx -> tx.getUtxosToInclude().stream()).collect(Collectors.toSet()))).collect(Collectors.toMap(tuple -> (String)tuple._1, tuple -> (Set)tuple._2));
    }

    private static class PaymentTransactionGroupingKey {
        private final String sender;
        private final String receiver;
        private final String datumHash;

        public PaymentTransactionGroupingKey(String sender, String receiver, String datumHash) {
            this.sender = sender;
            this.receiver = receiver;
            this.datumHash = datumHash;
        }

        public String getSender() {
            return this.sender;
        }

        public String getReceiver() {
            return this.receiver;
        }

        public String getDatumHash() {
            return this.datumHash;
        }

        public String toString() {
            return "UtxoTransactionBodyBuilder.PaymentTransactionGroupingKey(sender=" + this.getSender() + ", receiver=" + this.getReceiver() + ", datumHash=" + this.getDatumHash() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentTransactionGroupingKey)) {
                return false;
            }
            PaymentTransactionGroupingKey other = (PaymentTransactionGroupingKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sender = this.getSender();
            String other$sender = other.getSender();
            if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
                return false;
            }
            String this$receiver = this.getReceiver();
            String other$receiver = other.getReceiver();
            if (this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver)) {
                return false;
            }
            String this$datumHash = this.getDatumHash();
            String other$datumHash = other.getDatumHash();
            return !(this$datumHash == null ? other$datumHash != null : !this$datumHash.equals(other$datumHash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PaymentTransactionGroupingKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sender = this.getSender();
            result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
            String $receiver = this.getReceiver();
            result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
            String $datumHash = this.getDatumHash();
            result = result * 59 + ($datumHash == null ? 43 : $datumHash.hashCode());
            return result;
        }
    }

    private static class CalculatedOutputs {
        private final Map<String, BigInteger> miscCostPerSender = new HashMap<String, BigInteger>();
        private final BigInteger totalFee;
        private final List<TransactionOutput> transactionOutputs = new ArrayList<TransactionOutput>();

        public CalculatedOutputs(Map<String, BigInteger> miscCostPerSender, List<TransactionOutput> transactionOutputs, BigInteger totalFee) {
            this.totalFee = totalFee;
            if (miscCostPerSender != null) {
                this.miscCostPerSender.putAll(miscCostPerSender);
            }
            if (transactionOutputs != null) {
                this.transactionOutputs.addAll(transactionOutputs);
            }
        }

        public Map<String, BigInteger> getMiscCostPerSender() {
            return this.miscCostPerSender;
        }

        public BigInteger getTotalFee() {
            return this.totalFee;
        }

        public List<TransactionOutput> getTransactionOutputs() {
            return this.transactionOutputs;
        }

        public String toString() {
            return "UtxoTransactionBodyBuilder.CalculatedOutputs(miscCostPerSender=" + this.getMiscCostPerSender() + ", totalFee=" + this.getTotalFee() + ", transactionOutputs=" + this.getTransactionOutputs() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CalculatedOutputs)) {
                return false;
            }
            CalculatedOutputs other = (CalculatedOutputs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, BigInteger> this$miscCostPerSender = this.getMiscCostPerSender();
            Map<String, BigInteger> other$miscCostPerSender = other.getMiscCostPerSender();
            if (this$miscCostPerSender == null ? other$miscCostPerSender != null : !((Object)this$miscCostPerSender).equals(other$miscCostPerSender)) {
                return false;
            }
            BigInteger this$totalFee = this.getTotalFee();
            BigInteger other$totalFee = other.getTotalFee();
            if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
                return false;
            }
            List<TransactionOutput> this$transactionOutputs = this.getTransactionOutputs();
            List<TransactionOutput> other$transactionOutputs = other.getTransactionOutputs();
            return !(this$transactionOutputs == null ? other$transactionOutputs != null : !((Object)this$transactionOutputs).equals(other$transactionOutputs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CalculatedOutputs;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, BigInteger> $miscCostPerSender = this.getMiscCostPerSender();
            result = result * 59 + ($miscCostPerSender == null ? 43 : ((Object)$miscCostPerSender).hashCode());
            BigInteger $totalFee = this.getTotalFee();
            result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
            List<TransactionOutput> $transactionOutputs = this.getTransactionOutputs();
            result = result * 59 + ($transactionOutputs == null ? 43 : ((Object)$transactionOutputs).hashCode());
            return result;
        }
    }

    private static class CalculatedChangeTransactions {
        private final List<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
        private final List<TransactionOutput> transactionOutputs = new ArrayList<TransactionOutput>();
        private final List<Utxo> additionalUtxos = new ArrayList<Utxo>();

        public CalculatedChangeTransactions(List<TransactionInput> transactionInputs, List<TransactionOutput> transactionOutputs, List<Utxo> additionalUtxos) {
            if (transactionInputs != null) {
                this.transactionInputs.addAll(transactionInputs);
            }
            if (transactionOutputs != null) {
                this.transactionOutputs.addAll(transactionOutputs);
            }
            if (additionalUtxos != null) {
                this.additionalUtxos.addAll(additionalUtxos);
            }
        }

        public List<TransactionInput> getTransactionInputs() {
            return this.transactionInputs;
        }

        public List<TransactionOutput> getTransactionOutputs() {
            return this.transactionOutputs;
        }

        public List<Utxo> getAdditionalUtxos() {
            return this.additionalUtxos;
        }

        public String toString() {
            return "UtxoTransactionBodyBuilder.CalculatedChangeTransactions(transactionInputs=" + this.getTransactionInputs() + ", transactionOutputs=" + this.getTransactionOutputs() + ", additionalUtxos=" + this.getAdditionalUtxos() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CalculatedChangeTransactions)) {
                return false;
            }
            CalculatedChangeTransactions other = (CalculatedChangeTransactions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<TransactionInput> this$transactionInputs = this.getTransactionInputs();
            List<TransactionInput> other$transactionInputs = other.getTransactionInputs();
            if (this$transactionInputs == null ? other$transactionInputs != null : !((Object)this$transactionInputs).equals(other$transactionInputs)) {
                return false;
            }
            List<TransactionOutput> this$transactionOutputs = this.getTransactionOutputs();
            List<TransactionOutput> other$transactionOutputs = other.getTransactionOutputs();
            if (this$transactionOutputs == null ? other$transactionOutputs != null : !((Object)this$transactionOutputs).equals(other$transactionOutputs)) {
                return false;
            }
            List<Utxo> this$additionalUtxos = this.getAdditionalUtxos();
            List<Utxo> other$additionalUtxos = other.getAdditionalUtxos();
            return !(this$additionalUtxos == null ? other$additionalUtxos != null : !((Object)this$additionalUtxos).equals(other$additionalUtxos));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CalculatedChangeTransactions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<TransactionInput> $transactionInputs = this.getTransactionInputs();
            result = result * 59 + ($transactionInputs == null ? 43 : ((Object)$transactionInputs).hashCode());
            List<TransactionOutput> $transactionOutputs = this.getTransactionOutputs();
            result = result * 59 + ($transactionOutputs == null ? 43 : ((Object)$transactionOutputs).hashCode());
            List<Utxo> $additionalUtxos = this.getAdditionalUtxos();
            result = result * 59 + ($additionalUtxos == null ? 43 : ((Object)$additionalUtxos).hashCode());
            return result;
        }
    }

    private static class OutputAmount {
        private final BigInteger baseAmount;
        private final List<MultiAsset> multiAssets = new ArrayList<MultiAsset>();

        public OutputAmount(BigInteger baseAmount, List<MultiAsset> multiAssets) {
            this.baseAmount = baseAmount;
            if (multiAssets != null) {
                this.multiAssets.addAll(multiAssets);
            }
        }

        public BigInteger getBaseAmount() {
            return this.baseAmount;
        }

        public List<MultiAsset> getMultiAssets() {
            return this.multiAssets;
        }

        public String toString() {
            return "UtxoTransactionBodyBuilder.OutputAmount(baseAmount=" + this.getBaseAmount() + ", multiAssets=" + this.getMultiAssets() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OutputAmount)) {
                return false;
            }
            OutputAmount other = (OutputAmount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$baseAmount = this.getBaseAmount();
            BigInteger other$baseAmount = other.getBaseAmount();
            if (this$baseAmount == null ? other$baseAmount != null : !((Object)this$baseAmount).equals(other$baseAmount)) {
                return false;
            }
            List<MultiAsset> this$multiAssets = this.getMultiAssets();
            List<MultiAsset> other$multiAssets = other.getMultiAssets();
            return !(this$multiAssets == null ? other$multiAssets != null : !((Object)this$multiAssets).equals(other$multiAssets));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OutputAmount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $baseAmount = this.getBaseAmount();
            result = result * 59 + ($baseAmount == null ? 43 : ((Object)$baseAmount).hashCode());
            List<MultiAsset> $multiAssets = this.getMultiAssets();
            result = result * 59 + ($multiAssets == null ? 43 : ((Object)$multiAssets).hashCode());
            return result;
        }
    }
}

