/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.api.model;

import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.AssetUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Utxo {
    private String txHash;
    private int outputIndex;
    private List<Amount> amount;
    private String dataHash;
    private String inlineDatum;
    private String referenceScriptHash;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Utxo utxo = (Utxo)o;
        return this.outputIndex == utxo.outputIndex && this.txHash.equals(utxo.txHash);
    }

    public int hashCode() {
        return Objects.hash(this.txHash, this.outputIndex);
    }

    public Value toValue() {
        Amount loveLaceAmount = this.amount.stream().filter(amt -> "lovelace".equals(amt.getUnit())).findFirst().orElse(new Amount("lovelace", BigInteger.ZERO));
        List<MultiAsset> multiAssets = this.amount.stream().filter(amt -> !"lovelace".equals(amt.getUnit())).collect(Collectors.groupingBy(amt -> (String)AssetUtil.getPolicyIdAndAssetName((String)amt.getUnit())._1)).entrySet().stream().map(entry -> {
            List<Asset> assets = ((List)entry.getValue()).stream().map(amount -> new Asset((String)AssetUtil.getPolicyIdAndAssetName((String)amount.getUnit())._2, amount.getQuantity())).collect(Collectors.toList());
            MultiAsset multiAsset = new MultiAsset();
            multiAsset.setPolicyId((String)entry.getKey());
            multiAsset.setAssets(assets);
            return multiAsset;
        }).collect(Collectors.toList());
        return new Value(loveLaceAmount.getQuantity(), multiAssets);
    }

    public static UtxoBuilder builder() {
        return new UtxoBuilder();
    }

    public String getTxHash() {
        return this.txHash;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public List<Amount> getAmount() {
        return this.amount;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public String getInlineDatum() {
        return this.inlineDatum;
    }

    public String getReferenceScriptHash() {
        return this.referenceScriptHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public void setOutputIndex(int outputIndex) {
        this.outputIndex = outputIndex;
    }

    public void setAmount(List<Amount> amount) {
        this.amount = amount;
    }

    public void setDataHash(String dataHash) {
        this.dataHash = dataHash;
    }

    public void setInlineDatum(String inlineDatum) {
        this.inlineDatum = inlineDatum;
    }

    public void setReferenceScriptHash(String referenceScriptHash) {
        this.referenceScriptHash = referenceScriptHash;
    }

    public String toString() {
        return "Utxo(txHash=" + this.getTxHash() + ", outputIndex=" + this.getOutputIndex() + ", amount=" + this.getAmount() + ", dataHash=" + this.getDataHash() + ", inlineDatum=" + this.getInlineDatum() + ", referenceScriptHash=" + this.getReferenceScriptHash() + ")";
    }

    public Utxo() {
    }

    public Utxo(String txHash, int outputIndex, List<Amount> amount, String dataHash, String inlineDatum, String referenceScriptHash) {
        this.txHash = txHash;
        this.outputIndex = outputIndex;
        this.amount = amount;
        this.dataHash = dataHash;
        this.inlineDatum = inlineDatum;
        this.referenceScriptHash = referenceScriptHash;
    }

    public static class UtxoBuilder {
        private String txHash;
        private int outputIndex;
        private List<Amount> amount;
        private String dataHash;
        private String inlineDatum;
        private String referenceScriptHash;

        UtxoBuilder() {
        }

        public UtxoBuilder txHash(String txHash) {
            this.txHash = txHash;
            return this;
        }

        public UtxoBuilder outputIndex(int outputIndex) {
            this.outputIndex = outputIndex;
            return this;
        }

        public UtxoBuilder amount(List<Amount> amount) {
            this.amount = amount;
            return this;
        }

        public UtxoBuilder dataHash(String dataHash) {
            this.dataHash = dataHash;
            return this;
        }

        public UtxoBuilder inlineDatum(String inlineDatum) {
            this.inlineDatum = inlineDatum;
            return this;
        }

        public UtxoBuilder referenceScriptHash(String referenceScriptHash) {
            this.referenceScriptHash = referenceScriptHash;
            return this;
        }

        public Utxo build() {
            return new Utxo(this.txHash, this.outputIndex, this.amount, this.dataHash, this.inlineDatum, this.referenceScriptHash);
        }

        public String toString() {
            return "Utxo.UtxoBuilder(txHash=" + this.txHash + ", outputIndex=" + this.outputIndex + ", amount=" + this.amount + ", dataHash=" + this.dataHash + ", inlineDatum=" + this.inlineDatum + ", referenceScriptHash=" + this.referenceScriptHash + ")";
        }
    }
}

