/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip25;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.cip.cip25.NFTFile;
import com.bloxbean.cardano.client.cip.cip25.NFTMetadataUtil;
import com.bloxbean.cardano.client.cip.cip25.NFTProperties;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;
import com.bloxbean.cardano.client.metadata.cbor.MetadataHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class NFT
extends NFTProperties {
    public static final String IMAGE_KEY = "image";
    public static final String MEDIA_TYPE_KEY = "mediaType";
    public static final String DESCRIPTION_KEY = "description";
    public static final String NAME_KEY = "name";
    public static final String FILES_KEY = "files";
    private String assetName;

    private NFT() {
    }

    private NFT(Map map) {
        super(map);
    }

    public static NFT create() {
        return new NFT();
    }

    static NFT create(Map map) {
        return new NFT(map);
    }

    public NFT assetName(String assetName) {
        this.assetName = assetName;
        return this;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public NFT name(String name) {
        this.put(NAME_KEY, name);
        return this;
    }

    public String getName() {
        return (String)this.get(NAME_KEY);
    }

    public NFT image(String imageUri) {
        NFTMetadataUtil.addSingleOrMultipleValue(this, IMAGE_KEY, imageUri);
        return this;
    }

    public NFT setImages(List<String> imageUris) {
        if (imageUris == null || imageUris.size() == 0) {
            return this;
        }
        CBORMetadataList list = new CBORMetadataList();
        for (String imageUri : imageUris) {
            list.add(imageUri);
        }
        this.put(IMAGE_KEY, list);
        return this;
    }

    public List<String> getImages() {
        Object value = this.get(IMAGE_KEY);
        if (value instanceof String) {
            return Arrays.asList((String)value);
        }
        if (value instanceof CBORMetadataList) {
            Array array = ((CBORMetadataList)value).getArray();
            return array.getDataItems().stream().map(di -> (String)MetadataHelper.extractActualValue(di)).collect(Collectors.toList());
        }
        return null;
    }

    public NFT mediaType(String mediaType) {
        this.put(MEDIA_TYPE_KEY, mediaType);
        return this;
    }

    public String getMediaType() {
        return (String)this.get(MEDIA_TYPE_KEY);
    }

    public NFT description(String description) {
        NFTMetadataUtil.addSingleOrMultipleValue(this, DESCRIPTION_KEY, description);
        return this;
    }

    public List<String> getDescriptions() {
        Object value = this.get(DESCRIPTION_KEY);
        if (value instanceof String) {
            return Arrays.asList((String)value);
        }
        if (value instanceof CBORMetadataList) {
            Array array = ((CBORMetadataList)value).getArray();
            return array.getDataItems().stream().map(di -> (String)MetadataHelper.extractActualValue(di)).collect(Collectors.toList());
        }
        return null;
    }

    public NFT addFile(NFTFile nftFile) {
        CBORMetadataList files = (CBORMetadataList)this.get(FILES_KEY);
        if (files == null) {
            files = new CBORMetadataList();
            this.put(FILES_KEY, files);
        }
        files.add(nftFile);
        return this;
    }

    public List<NFTFile> getFiles() {
        CBORMetadataList files = (CBORMetadataList)this.get(FILES_KEY);
        ArrayList<NFTFile> nftFiles = new ArrayList<NFTFile>();
        for (DataItem di : files.getArray().getDataItems()) {
            NFTFile nftFile = NFTFile.create((Map)di);
            nftFiles.add(nftFile);
        }
        return nftFiles;
    }

    @Override
    public NFT property(String name, String value) {
        return (NFT)super.property(name, value);
    }

    @Override
    public NFT property(String name, java.util.Map<String, String> values) {
        return (NFT)super.property(name, values);
    }

    @Override
    public NFT property(String name, List<String> values) {
        return (NFT)super.property(name, values);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

