/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip25;

import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.cip.cip25.NFT;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadata;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import java.math.BigInteger;

public class NFTMetadata
extends CBORMetadata {
    private static final BigInteger LABEL = BigInteger.valueOf(721L);
    public static final String VERSION_KEY = "version";
    private String version = "1.0";
    private CBORMetadataMap policyMap;

    private NFTMetadata() {
        this.policyMap = new CBORMetadataMap();
        this.policyMap.put(VERSION_KEY, this.version);
        this.put(LABEL, this.policyMap);
    }

    private NFTMetadata(Map map) {
        super(map);
    }

    public static NFTMetadata create() {
        return new NFTMetadata();
    }

    public static NFTMetadata create(byte[] cborBytes) {
        Map map = NFTMetadata.deserialize(cborBytes).getData();
        return new NFTMetadata(map);
    }

    public NFTMetadata addNFT(String policyId, NFT nft) {
        CBORMetadataMap nftListMap = (CBORMetadataMap)this.policyMap.get(policyId);
        if (nftListMap == null) {
            nftListMap = new CBORMetadataMap();
            this.policyMap.put(policyId, nftListMap);
        }
        nftListMap.put(nft.getAssetName(), (CBORMetadataMap)nft);
        return this;
    }

    public NFT getNFT(String policyId, String assetName) {
        CBORMetadataMap nftListMap = (CBORMetadataMap)this.policyMap.get(policyId);
        if (nftListMap == null) {
            return null;
        }
        CBORMetadataMap nftMap = (CBORMetadataMap)nftListMap.get(assetName);
        if (nftMap != null) {
            NFT nft = NFT.create(nftMap.getMap());
            nft.assetName(assetName);
            return nft;
        }
        return null;
    }

    public NFTMetadata removeNFT(String policyId, String assetName) {
        CBORMetadataMap nftListMap = (CBORMetadataMap)this.policyMap.get(policyId);
        if (nftListMap != null) {
            nftListMap.remove(assetName);
        }
        return this;
    }

    public NFTMetadata version(String version) {
        this.version = version;
        this.policyMap.put(VERSION_KEY, version);
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

