/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip30;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressService;
import com.bloxbean.cardano.client.cip.cip30.DataSignError;
import com.bloxbean.cardano.client.cip.cip30.DataSignature;
import com.bloxbean.cardano.client.cip.cip8.COSEKey;
import com.bloxbean.cardano.client.cip.cip8.COSESign1;
import com.bloxbean.cardano.client.cip.cip8.HeaderMap;
import com.bloxbean.cardano.client.cip.cip8.Headers;
import com.bloxbean.cardano.client.cip.cip8.ProtectedHeaderMap;
import com.bloxbean.cardano.client.cip.cip8.SigStructure;
import com.bloxbean.cardano.client.cip.cip8.builder.COSESign1Builder;
import com.bloxbean.cardano.client.config.Configuration;
import com.bloxbean.cardano.client.util.HexUtil;
import lombok.NonNull;

public enum CIP30DataSigner {
    INSTANCE;


    public DataSignature signData(@NonNull byte[] addressBytes, @NonNull byte[] payload, @NonNull Account signer) throws DataSignError {
        if (addressBytes == null) {
            throw new NullPointerException("addressBytes is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
        byte[] pvtKey = signer.privateKeyBytes();
        byte[] pubKey = signer.publicKeyBytes();
        return this.signData(addressBytes, payload, pvtKey, pubKey);
    }

    public DataSignature signData(@NonNull byte[] addressBytes, @NonNull byte[] payload, @NonNull byte[] pvtKey, @NonNull byte[] pubKey) throws DataSignError {
        if (addressBytes == null) {
            throw new NullPointerException("addressBytes is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (pvtKey == null) {
            throw new NullPointerException("pvtKey is marked non-null but is null");
        }
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        try {
            HeaderMap protectedHeaderMap = new HeaderMap().algorithmId(-8L).keyId(addressBytes).addOtherHeader("address", (DataItem)new ByteString(addressBytes));
            Headers headers = new Headers()._protected(new ProtectedHeaderMap(protectedHeaderMap)).unprotected(new HeaderMap());
            COSESign1Builder coseSign1Builder = new COSESign1Builder(headers, payload, false);
            SigStructure sigStructure = coseSign1Builder.makeDataToSign();
            byte[] signature = pvtKey.length >= 64 ? Configuration.INSTANCE.getSigningProvider().signExtended(sigStructure.serializeAsBytes(), pvtKey) : Configuration.INSTANCE.getSigningProvider().sign(sigStructure.serializeAsBytes(), pvtKey);
            COSESign1 coseSign1 = coseSign1Builder.build(signature);
            COSEKey coseKey = new COSEKey().keyType(1L).keyId(addressBytes).algorithmId(-8L).addOtherHeader(-1L, (DataItem)new UnsignedInteger(6L)).addOtherHeader(-2L, (DataItem)new ByteString(pubKey));
            return new DataSignature(HexUtil.encodeHexString(coseSign1.serializeAsBytes()), HexUtil.encodeHexString(coseKey.serializeAsBytes()));
        }
        catch (Exception e) {
            throw new DataSignError("Error signing data", e);
        }
    }

    public boolean verify(@NonNull DataSignature dataSignature) {
        if (dataSignature == null) {
            throw new NullPointerException("dataSignature is marked non-null but is null");
        }
        COSESign1 coseSign1 = dataSignature.coseSign1();
        COSEKey coseKey = dataSignature.coseKey();
        byte[] pubKey = coseKey.otherHeaderAsBytes(-2L);
        SigStructure sigStructure = coseSign1.signedData();
        byte[] signature = coseSign1.signature();
        boolean sigVerified = Configuration.INSTANCE.getSigningProvider().verify(signature, sigStructure.serializeAsBytes(), pubKey);
        byte[] addressBytes = coseSign1.headers()._protected().getAsHeaderMap().otherHeaderAsBytes("address");
        Address address = new Address(addressBytes);
        boolean addressVerified = AddressService.getInstance().verifyAddress(address, pubKey);
        return sigVerified && addressVerified;
    }
}

