/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip30;

import com.bloxbean.cardano.client.cip.cip8.COSEKey;
import com.bloxbean.cardano.client.cip.cip8.COSESign1;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.JsonFieldWriter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.NonNull;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class DataSignature
implements JsonFieldWriter {
    private String signature;
    private String key;
    @JsonIgnore
    private COSESign1 coseSign1;
    @JsonIgnore
    private COSEKey coseKey;

    public DataSignature(@NonNull String signature, @NonNull String key) {
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.signature(signature);
        this.key(key);
    }

    public DataSignature signature(@NonNull String signature) {
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        this.signature = signature;
        this.coseSign1 = COSESign1.deserialize(HexUtil.decodeHexString(signature));
        return this;
    }

    public DataSignature key(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.coseKey = COSEKey.deserialize(HexUtil.decodeHexString(key));
        return this;
    }

    public byte[] address() {
        if (this.coseSign1 != null) {
            return this.coseSign1.headers()._protected().getAsHeaderMap().otherHeaderAsBytes("address");
        }
        return null;
    }

    public Integer crv() {
        if (this.coseKey != null) {
            return (int)this.coseKey.otherHeaderAsLong(-1L);
        }
        return null;
    }

    public byte[] x() {
        if (this.coseKey != null) {
            return this.coseKey.otherHeaderAsBytes(-2L);
        }
        return null;
    }

    public static DataSignature from(String json) throws JsonProcessingException {
        return (DataSignature)mapper.readValue(json, DataSignature.class);
    }

    public String signature() {
        return this.signature;
    }

    public String key() {
        return this.key;
    }

    public COSESign1 coseSign1() {
        return this.coseSign1;
    }

    public COSEKey coseKey() {
        return this.coseKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSignature)) {
            return false;
        }
        DataSignature other = (DataSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$signature = this.signature();
        String other$signature = other.signature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        String this$key = this.key();
        String other$key = other.key();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSignature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $signature = this.signature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        String $key = this.key();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "DataSignature(signature=" + this.signature() + ", key=" + this.key() + ", coseSign1=" + this.coseSign1() + ", coseKey=" + this.coseKey() + ")";
    }

    public DataSignature() {
    }
}

