/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.cip.cip8.builder;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import com.bloxbean.cardano.client.cip.cip8.COSESign1;
import com.bloxbean.cardano.client.cip.cip8.Headers;
import com.bloxbean.cardano.client.cip.cip8.SigContext;
import com.bloxbean.cardano.client.cip.cip8.SigStructure;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import java.util.Arrays;

public class COSESign1Builder {
    private Headers headers;
    private byte[] payload;
    private byte[] externalAad;
    private boolean isPayloadExternal;
    private boolean hashed;

    public COSESign1Builder(Headers headers, byte[] payload, boolean isPayloadExternal) {
        this.headers = headers;
        this.payload = payload;
        this.isPayloadExternal = isPayloadExternal;
    }

    public SigStructure makeDataToSign() {
        Headers headersCopy = this.headers.copy();
        return new SigStructure().sigContext(SigContext.Signature1).bodyProtected(headersCopy._protected()).externalAad(this.externalAad != null ? (byte[])this.externalAad.clone() : new byte[]{}).payload((byte[])this.payload.clone());
    }

    public COSESign1 build(byte[] signedSigStructure) {
        Headers allHeader = this.headers.copy();
        allHeader.unprotected().addOtherHeader("hashed", (DataItem)(this.hashed ? SimpleValue.TRUE : SimpleValue.FALSE));
        byte[] finalPayload = this.hashed ? Blake2bUtil.blake2bHash224(this.payload) : (byte[])this.payload.clone();
        return new COSESign1().headers(allHeader).payload(this.isPayloadExternal ? null : finalPayload).signature(signedSigStructure);
    }

    public Headers headers() {
        return this.headers;
    }

    public byte[] payload() {
        return this.payload;
    }

    public byte[] externalAad() {
        return this.externalAad;
    }

    public boolean isPayloadExternal() {
        return this.isPayloadExternal;
    }

    public boolean hashed() {
        return this.hashed;
    }

    public COSESign1Builder headers(Headers headers) {
        this.headers = headers;
        return this;
    }

    public COSESign1Builder payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public COSESign1Builder externalAad(byte[] externalAad) {
        this.externalAad = externalAad;
        return this;
    }

    public COSESign1Builder isPayloadExternal(boolean isPayloadExternal) {
        this.isPayloadExternal = isPayloadExternal;
        return this;
    }

    public COSESign1Builder hashed(boolean hashed) {
        this.hashed = hashed;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COSESign1Builder)) {
            return false;
        }
        COSESign1Builder other = (COSESign1Builder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPayloadExternal() != other.isPayloadExternal()) {
            return false;
        }
        if (this.hashed() != other.hashed()) {
            return false;
        }
        Headers this$headers = this.headers();
        Headers other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        if (!Arrays.equals(this.payload(), other.payload())) {
            return false;
        }
        return Arrays.equals(this.externalAad(), other.externalAad());
    }

    protected boolean canEqual(Object other) {
        return other instanceof COSESign1Builder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPayloadExternal() ? 79 : 97);
        result = result * 59 + (this.hashed() ? 79 : 97);
        Headers $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.payload());
        result = result * 59 + Arrays.hashCode(this.externalAad());
        return result;
    }

    public String toString() {
        return "COSESign1Builder(headers=" + this.headers() + ", payload=" + Arrays.toString(this.payload()) + ", externalAad=" + Arrays.toString(this.externalAad()) + ", isPayloadExternal=" + this.isPayloadExternal() + ", hashed=" + this.hashed() + ")";
    }
}

