/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.coinselection.impl;

import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.exception.InsufficientBalanceException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.coinselection.exception.InputsLimitExceededException;
import com.bloxbean.cardano.client.coinselection.impl.LargestFirstUtxoSelectionStrategy;
import com.bloxbean.cardano.client.transaction.spec.PlutusData;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RandomImproveUtxoSelectionStrategy
implements UtxoSelectionStrategy {
    private final SecureRandom secureRandom = RandomImproveUtxoSelectionStrategy.initRandomGenerator();
    private final UtxoSupplier utxoSupplier;
    private boolean ignoreUtxosWithDatumHash;

    public RandomImproveUtxoSelectionStrategy(UtxoSupplier utxoSupplier) {
        this(utxoSupplier, true);
    }

    public RandomImproveUtxoSelectionStrategy(UtxoSupplier utxoSupplier, boolean ignoreUtxosWithDatumHash) {
        this.utxoSupplier = utxoSupplier;
        this.ignoreUtxosWithDatumHash = ignoreUtxosWithDatumHash;
    }

    @Override
    public Set<Utxo> select(String address, List<Amount> outputAmounts, String datumHash, PlutusData inlineDatum, Set<Utxo> utxosToExclude, int maxUtxoSelectionLimit) {
        try {
            RandomPhaseResult randomPhaseResult = this.selectRandom(outputAmounts, this.utxoSupplier.getAll(address), datumHash, inlineDatum, utxosToExclude, maxUtxoSelectionLimit);
            Set<Utxo> improvedResult = this.improve(outputAmounts, randomPhaseResult, datumHash, inlineDatum, utxosToExclude, maxUtxoSelectionLimit);
            return Stream.concat(randomPhaseResult.getSelectedUtxos().stream(), improvedResult.stream()).collect(Collectors.toSet());
        }
        catch (InputsLimitExceededException e) {
            UtxoSelectionStrategy fallback = this.fallback();
            if (fallback != null) {
                return fallback.select(address, outputAmounts, datumHash, inlineDatum, utxosToExclude, maxUtxoSelectionLimit);
            }
            throw new ApiRuntimeException("Input limit exceeded and no fallback provided", e);
        }
    }

    private Set<Utxo> improve(List<Amount> outputAmounts, RandomPhaseResult randomPhaseResult, String datumHash, PlutusData inlineDatum, Set<Utxo> utxosToExclude, int maxUtxoSelectionLimit) {
        Map outputsToProcess = outputAmounts.stream().collect(Collectors.groupingBy(Amount::getUnit, Collectors.reducing(BigInteger.ZERO, Amount::getQuantity, BigInteger::add))).entrySet().stream().filter(entry -> BigInteger.ZERO.compareTo((BigInteger)entry.getValue()) < 0).sorted(Comparator.comparing(Map.Entry::getValue)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, BigInteger::add, TreeMap::new));
        HashSet<Utxo> selectedUtxos = new HashSet<Utxo>();
        block0: for (Map.Entry entry2 : outputsToProcess.entrySet()) {
            Utxo randomUtxo;
            ArrayList<Utxo> availableUtxos = new ArrayList<Utxo>(randomPhaseResult.getAllAvailableUtxos());
            availableUtxos.removeAll(selectedUtxos);
            availableUtxos.removeAll(randomPhaseResult.getSelectedUtxos());
            Amount requiredAmount = new Amount((String)entry2.getKey(), (BigInteger)entry2.getValue());
            BigInteger idealTarget = ((BigInteger)entry2.getValue()).multiply(BigInteger.valueOf(2L));
            BigInteger maxTarget = ((BigInteger)entry2.getValue()).multiply(BigInteger.valueOf(3L));
            BigInteger processedAmount = Stream.concat(selectedUtxos.stream(), randomPhaseResult.getSelectedUtxos().stream()).flatMap(utxo -> utxo.getAmount().stream()).filter(utxo -> RandomImproveUtxoSelectionStrategy.isEqualUnit(utxo.getUnit(), (String)entry2.getKey())).map(Amount::getQuantity).reduce(BigInteger.ZERO, BigInteger::add);
            if (processedAmount.compareTo(maxTarget) >= 0 || processedAmount.equals(idealTarget)) continue;
            while ((randomUtxo = this.selectRandomUtxo(requiredAmount.getUnit(), availableUtxos, datumHash, inlineDatum, utxosToExclude)) != null) {
                boolean isImprovement;
                Amount utxoAmount = randomUtxo.getAmount().stream().filter(utxo -> RandomImproveUtxoSelectionStrategy.isEqualUnit(utxo.getUnit(), requiredAmount.getUnit())).reduce(new Amount(requiredAmount.getUnit(), BigInteger.ZERO), RandomImproveUtxoSelectionStrategy::add);
                BigInteger potentiallyNewProcessedAmount = processedAmount.add(utxoAmount.getQuantity());
                boolean bl = isImprovement = idealTarget.subtract(potentiallyNewProcessedAmount).abs().compareTo(idealTarget.subtract(processedAmount).abs()) < 0 && potentiallyNewProcessedAmount.compareTo(maxTarget) <= 0 && randomPhaseResult.getSelectedUtxos().size() + selectedUtxos.size() < maxUtxoSelectionLimit;
                if (isImprovement) {
                    selectedUtxos.add(randomUtxo);
                    processedAmount = potentiallyNewProcessedAmount;
                    if (processedAmount.equals(idealTarget)) continue block0;
                }
                availableUtxos.remove(randomUtxo);
            }
        }
        return selectedUtxos;
    }

    private RandomPhaseResult selectRandom(List<Amount> outputAmounts, List<Utxo> allAvailableUtxos, String datumHash, PlutusData inlineDatum, Set<Utxo> utxosToExclude, int maxUtxoSelectionLimit) throws InputsLimitExceededException {
        if (allAvailableUtxos == null || allAvailableUtxos.isEmpty()) {
            throw new InsufficientBalanceException("No UTXOs available");
        }
        Map outputsToProcess = outputAmounts.stream().collect(Collectors.groupingBy(Amount::getUnit, Collectors.reducing(BigInteger.ZERO, Amount::getQuantity, BigInteger::add))).entrySet().stream().filter(entry -> BigInteger.ZERO.compareTo((BigInteger)entry.getValue()) < 0).sorted((it1, it2) -> ((BigInteger)it2.getValue()).compareTo((BigInteger)it1.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, BigInteger::add, TreeMap::new));
        ArrayList<Utxo> availableUtxos = new ArrayList<Utxo>(allAvailableUtxos);
        HashMap<String, BigInteger> remainingOutputs = new HashMap<String, BigInteger>(outputsToProcess);
        HashSet<Utxo> selectedUtxos = new HashSet<Utxo>();
        for (Map.Entry entry2 : outputsToProcess.entrySet()) {
            while (remainingOutputs.containsKey(entry2.getKey()) && BigInteger.ZERO.compareTo((BigInteger)remainingOutputs.get(entry2.getKey())) < 0) {
                String requiredUnit = (String)entry2.getKey();
                Utxo randomUtxo = this.selectRandomUtxo(requiredUnit, availableUtxos, datumHash, inlineDatum, utxosToExclude);
                if (randomUtxo == null) {
                    throw new InsufficientBalanceException("Unable to find random UTXO for " + requiredUnit);
                }
                selectedUtxos.add(randomUtxo);
                availableUtxos.remove(randomUtxo);
                for (Amount amountToRemove : randomUtxo.getAmount()) {
                    BigInteger existing = remainingOutputs.getOrDefault(amountToRemove.getUnit(), BigInteger.ZERO);
                    BigInteger adjusted = existing.subtract(amountToRemove.getQuantity());
                    if (BigInteger.ZERO.compareTo(adjusted) < 0) {
                        remainingOutputs.put(amountToRemove.getUnit(), adjusted);
                        continue;
                    }
                    remainingOutputs.remove(amountToRemove.getUnit());
                }
                if (remainingOutputs.isEmpty() || selectedUtxos.size() <= maxUtxoSelectionLimit) continue;
                throw new InputsLimitExceededException("Selection limit of " + maxUtxoSelectionLimit + " utxos reached with " + remainingOutputs + " remaining");
            }
        }
        return new RandomPhaseResult(selectedUtxos, availableUtxos);
    }

    private Utxo selectRandomUtxo(String requiredAsset, List<Utxo> allAvailableUtxos, String datumHash, PlutusData inlineDatum, Set<Utxo> utxosToExclude) {
        if (allAvailableUtxos.isEmpty()) {
            return null;
        }
        ArrayList<Utxo> available = new ArrayList<Utxo>(allAvailableUtxos);
        int randomIndex = this.secureRandom.nextInt(available.size());
        Utxo utxo = available.get(randomIndex);
        if (!this.accept(utxo) || utxosToExclude != null && utxosToExclude.contains(utxo) || utxo.getDataHash() != null && !utxo.getDataHash().isEmpty() && this.ignoreUtxosWithDatumHash || datumHash != null && !datumHash.isEmpty() && !datumHash.equals(utxo.getDataHash()) || inlineDatum != null && !inlineDatum.serializeToHex().equals(utxo.getInlineDatum())) {
            available.remove(randomIndex);
            return this.selectRandomUtxo(requiredAsset, available, datumHash, inlineDatum, utxosToExclude);
        }
        for (Amount amount : utxo.getAmount()) {
            if (!RandomImproveUtxoSelectionStrategy.isEqualUnit(amount.getUnit(), requiredAsset)) continue;
            return utxo;
        }
        available.remove(randomIndex);
        return this.selectRandomUtxo(requiredAsset, available, datumHash, inlineDatum, utxosToExclude);
    }

    private static Amount add(Amount a1, Amount a2) {
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        if (!RandomImproveUtxoSelectionStrategy.isEqualUnit(a1.getUnit(), a2.getUnit())) {
            throw new IllegalArgumentException("Failed to add [" + a1 + "] and [" + a2 + "] due to unit miss-match");
        }
        return new Amount(a1.getUnit(), a1.getQuantity().add(a2.getQuantity()));
    }

    private static boolean isEqualUnit(String u1, String u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        return u1.equals(u2);
    }

    protected boolean accept(Utxo utxo) {
        return true;
    }

    private static SecureRandom initRandomGenerator() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Invalid algorithm for secure random", e);
        }
    }

    @Override
    public UtxoSelectionStrategy fallback() {
        return new LargestFirstUtxoSelectionStrategy(this.utxoSupplier, this.ignoreUtxosWithDatumHash);
    }

    @Override
    public void setIgnoreUtxosWithDatumHash(boolean ignoreUtxosWithDatumHash) {
        this.ignoreUtxosWithDatumHash = ignoreUtxosWithDatumHash;
    }

    private static class RandomPhaseResult {
        private final Set<Utxo> selectedUtxos = new HashSet<Utxo>();
        private final List<Utxo> allAvailableUtxos = new ArrayList<Utxo>();

        public RandomPhaseResult(Set<Utxo> selectedUtxos, List<Utxo> allAvailableUtxos) {
            if (selectedUtxos != null) {
                this.selectedUtxos.addAll(selectedUtxos);
            }
            if (allAvailableUtxos != null) {
                this.allAvailableUtxos.addAll(allAvailableUtxos);
            }
        }

        public Set<Utxo> getSelectedUtxos() {
            return this.selectedUtxos;
        }

        public List<Utxo> getAllAvailableUtxos() {
            return this.allAvailableUtxos;
        }

        public String toString() {
            return "RandomImproveUtxoSelectionStrategy.RandomPhaseResult(selectedUtxos=" + this.getSelectedUtxos() + ", allAvailableUtxos=" + this.getAllAvailableUtxos() + ")";
        }
    }
}

