/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.common;

import co.nstant.in.cbor.CborException;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import java.math.BigInteger;
import java.util.List;

public class MinAdaCalculator {
    public static final BigInteger DUMMY_COIN_VAL = BigInteger.valueOf(1000000L);
    public static final String DUMMY_ADDRESS = "addr_test1qzx9hu8j4ah3auytk0mwcupd69hpc52t0cw39a65ndrah86djs784u92a3m5w475w3w35tyd6v3qumkze80j8a6h5tuqq5xe8y";
    private BigInteger coinsPerUtxoSize;

    public MinAdaCalculator(ProtocolParams protocolParams) {
        if (protocolParams.getCoinsPerUtxoSize() != null && !protocolParams.getCoinsPerUtxoSize().isEmpty()) {
            this.coinsPerUtxoSize = new BigInteger(protocolParams.getCoinsPerUtxoSize());
        }
    }

    public BigInteger calculateMinAda(TransactionOutput output) {
        TransactionOutput cloneOutput = output.toBuilder().build();
        if (cloneOutput.getValue().getCoin() == null || cloneOutput.getValue().getCoin().equals(BigInteger.ZERO) || cloneOutput.getValue().getCoin().compareTo(BigInteger.valueOf(100000L)) == -1) {
            Value updatedValue = Value.builder().coin(DUMMY_COIN_VAL).multiAssets(output.getValue().getMultiAssets()).build();
            cloneOutput.setValue(updatedValue);
        }
        if (cloneOutput.getAddress() == null) {
            cloneOutput.setAddress(DUMMY_ADDRESS);
        }
        try {
            byte[] serBytes = CborSerializationUtil.serialize(cloneOutput.serialize());
            int serSize = serBytes.length;
            return this.coinsPerUtxoSize.multiply(BigInteger.valueOf(serSize + 160));
        }
        catch (CborException | AddressExcepion | CborSerializationException e) {
            throw new CborRuntimeException("Cbor serialization error", (Exception)e);
        }
    }

    @Deprecated
    public BigInteger calculateMinAda(List<MultiAsset> multiAssetList, boolean hasDataHash) {
        return this.calculateMinAda(multiAssetList);
    }

    public BigInteger calculateMinAda(List<MultiAsset> multiAssetList) {
        Value value = Value.builder().coin(DUMMY_COIN_VAL).multiAssets(multiAssetList).build();
        TransactionOutput txOut = TransactionOutput.builder().address(DUMMY_ADDRESS).value(value).build();
        return this.calculateMinAda(txOut);
    }
}

