/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.crypto.bip32;

import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPrivateKey;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPublicKey;
import com.bloxbean.cardano.client.crypto.bip32.util.BytesUtil;
import com.bloxbean.cardano.client.crypto.bip32.util.Hmac;
import com.bloxbean.cardano.client.crypto.cip1852.DerivationPath;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.OSUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdKeyGenerator {
    private static final Logger logger = LoggerFactory.getLogger(HdKeyGenerator.class);
    private static final EdDSAParameterSpec ED25519SPEC = EdDSANamedCurveTable.getByName((String)"ed25519");
    public static final String MASTER_PATH = "m";

    public HdKeyPair getRootKeyPairFromEntropy(byte[] entropy) {
        byte[] xprv = this.pbkdf2HmacSha512("".toCharArray(), entropy, 4096, 768);
        xprv[0] = (byte)(xprv[0] & 0xF8);
        xprv[31] = (byte)(xprv[31] & 0x1F);
        xprv[31] = (byte)(xprv[31] | 0x40);
        return this.getKeyPairFromSecretKey(xprv, MASTER_PATH);
    }

    public HdKeyPair getAccountKeyPairFromSecretKey(byte[] xprv, DerivationPath derivationPath) {
        String accountPath = this.getPath(MASTER_PATH, derivationPath.getPurpose().getValue(), derivationPath.getPurpose().isHarden());
        accountPath = this.getPath(accountPath, derivationPath.getCoinType().getValue(), derivationPath.getCoinType().isHarden());
        accountPath = this.getPath(accountPath, derivationPath.getAccount().getValue(), derivationPath.getAccount().isHarden());
        return this.getKeyPairFromSecretKey(xprv, accountPath);
    }

    private HdKeyPair getKeyPairFromSecretKey(byte[] xprv, String path) {
        byte[] IL = Arrays.copyOfRange(xprv, 0, 64);
        byte[] IR = Arrays.copyOfRange(xprv, 64, 96);
        byte[] A = ED25519SPEC.getB().scalarMultiply(IL).toByteArray();
        HdPublicKey publicKey = new HdPublicKey();
        HdPrivateKey privateKey = new HdPrivateKey();
        privateKey.setKeyData(IL);
        privateKey.setChainCode(IR);
        publicKey.setKeyData(A);
        publicKey.setChainCode(IR);
        return new HdKeyPair(privateKey, publicKey, path);
    }

    private byte[] pbkdf2HmacSha512(char[] password, byte[] salt, int iterations, int keyLength) {
        try {
            if (OSUtil.isAndroid()) {
                PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA512Digest());
                gen.init(new String(password).getBytes(StandardCharsets.UTF_8), salt, iterations);
                byte[] dk = ((KeyParameter)gen.generateDerivedParameters(keyLength)).getKey();
                return dk;
            }
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, keyLength);
            SecretKey key = skf.generateSecret(spec);
            return key.getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public HdKeyPair getChildKeyPair(HdKeyPair parent, long child, boolean isHardened) {
        BigInteger order;
        BigInteger kLiBI;
        byte[] c;
        byte[] Z;
        byte[] data;
        byte[] I;
        HdPrivateKey privateKey = new HdPrivateKey();
        HdPublicKey publicKey = new HdPublicKey();
        HdKeyPair key = new HdKeyPair(privateKey, publicKey, this.getPath(parent.getPath(), child, isHardened));
        if (isHardened) {
            child += Integer.MIN_VALUE;
        }
        byte[] xChain = parent.getPrivateKey().getChainCode();
        if (isHardened) {
            BigInteger kpar = BytesUtil.parse256(parent.getPrivateKey().getKeyData());
            byte[] data2 = BytesUtil.merge({0}, BytesUtil.ser256(kpar), BytesUtil.ser32(child));
            I = Hmac.hmac512(data2, xChain);
        } else {
            byte[] data3 = BytesUtil.merge(parent.getPublicKey().getKeyData(), BytesUtil.ser32(child));
            I = Hmac.hmac512(data3, xChain);
        }
        byte[] IL = Arrays.copyOfRange(I, 0, 32);
        byte[] IR = Arrays.copyOfRange(I, 32, 64);
        byte[] childNumber = BytesUtil.ser32(child);
        privateKey.setVersion(parent.getPrivateKey().getVersion());
        privateKey.setDepth(parent.getPrivateKey().getDepth() + 1);
        privateKey.setChildNumber(childNumber);
        privateKey.setChainCode(IR);
        publicKey.setVersion(parent.getPublicKey().getVersion());
        publicKey.setDepth(parent.getPublicKey().getDepth() + 1);
        publicKey.setChildNumber(childNumber);
        publicKey.setChainCode(IR);
        byte[] kP = parent.getPrivateKey().getKeyData();
        byte[] kLP = Arrays.copyOfRange(kP, 0, 32);
        byte[] kRP = Arrays.copyOfRange(kP, 32, 64);
        byte[] AP = parent.getPublicKey().getKeyData();
        byte[] cP = parent.getPublicKey().getChainCode();
        if (isHardened) {
            data = BytesUtil.merge({0}, kLP, kRP, BytesUtil.ser32LE(child));
            Z = Hmac.hmac512(data, cP);
            data[0] = 1;
            c = Hmac.hmac512(data, cP);
        } else {
            data = BytesUtil.merge({2}, AP, BytesUtil.ser32LE(child));
            Z = Hmac.hmac512(data, cP);
            data[0] = 3;
            c = Hmac.hmac512(data, cP);
        }
        c = Arrays.copyOfRange(c, 32, 64);
        byte[] ZL = Arrays.copyOfRange(Z, 0, 28);
        byte[] ZR = Arrays.copyOfRange(Z, 32, 64);
        if (logger.isTraceEnabled()) {
            logger.trace("parent, kLP = " + HexUtil.encodeHexString(kLP));
            logger.trace("parent, kRP = " + HexUtil.encodeHexString(kRP));
            logger.trace("parent,  AP = " + HexUtil.encodeHexString(AP));
            logger.trace("parent,  cP = " + HexUtil.encodeHexString(cP));
        }
        if ((kLiBI = this.parseUnsignedLE(ZL).multiply(BigInteger.valueOf(8L)).add(this.parseUnsignedLE(kLP))).mod(order = BigInteger.valueOf(2L).pow(252).add(new BigInteger("27742317777372353535851937790883648493"))).equals(BigInteger.ZERO)) {
            return null;
        }
        IL = this.serializeUnsignedLE256(kLiBI);
        BigInteger kRiBI = this.parseUnsignedLE(ZR).add(this.parseUnsignedLE(kRP)).mod(BigInteger.valueOf(2L).pow(256));
        IR = this.serializeUnsignedLE256(kRiBI);
        I = BytesUtil.merge(IL, IR);
        byte[] A = ED25519SPEC.getB().scalarMultiply(IL).toByteArray();
        privateKey.setKeyData(I);
        publicKey.setKeyData(A);
        privateKey.setChainCode(c);
        publicKey.setChainCode(c);
        if (logger.isTraceEnabled()) {
            logger.trace("child, IL = " + HexUtil.encodeHexString(IL));
            logger.trace("child, IR = " + HexUtil.encodeHexString(IR));
            logger.trace("child,  A = " + HexUtil.encodeHexString(A));
            logger.trace("child,  c = " + HexUtil.encodeHexString(c));
        }
        return key;
    }

    public HdPublicKey getChildPublicKey(HdPublicKey parent, int child) {
        HdPublicKey publicKey = new HdPublicKey();
        byte[] AP = parent.getKeyData();
        byte[] pChain = parent.getChainCode();
        byte[] childNumber = BytesUtil.ser32(child);
        byte[] ApLE = this.serializeUnsignedLE256(this.parseUnsignedLE(AP));
        byte[] data = BytesUtil.merge({2}, ApLE, BytesUtil.ser32LE(child));
        byte[] Z = Hmac.hmac512(data, pChain);
        data[0] = 3;
        byte[] c = Hmac.hmac512(data, parent.getChainCode());
        c = Arrays.copyOfRange(c, 32, 64);
        byte[] ZL = Arrays.copyOfRange(Z, 0, 28);
        BigInteger kLiBI = this.parseUnsignedLE(ZL).multiply(BigInteger.valueOf(8L));
        byte[] kLi = this.serializeUnsignedLE256(kLiBI);
        GroupElement gp1 = new GroupElement(ED25519SPEC.getCurve(), AP);
        gp1 = gp1.toCached();
        GroupElement groupElement = ED25519SPEC.getB().scalarMultiply(kLi).add(gp1);
        byte[] Ai = groupElement.toByteArray();
        publicKey.setVersion(parent.getVersion());
        publicKey.setDepth(parent.getDepth() + 1);
        publicKey.setChildNumber(childNumber);
        publicKey.setChainCode(c);
        publicKey.setKeyData(Ai);
        return publicKey;
    }

    private String getPath(String parentPath, long child, boolean isHardened) {
        if (parentPath == null) {
            parentPath = MASTER_PATH;
        }
        return parentPath + "/" + child + (isHardened ? "'" : "");
    }

    private void reverse(byte[] input) {
        for (int i = 0; i < input.length / 2; ++i) {
            byte temp = input[i];
            input[i] = input[input.length - 1 - i];
            input[input.length - 1 - i] = temp;
        }
    }

    private BigInteger parseUnsignedLE(byte[] bytes) {
        byte[] temp = (byte[])bytes.clone();
        this.reverse(temp);
        return new BigInteger(1, temp);
    }

    private byte[] serializeUnsignedLE256(BigInteger bi) {
        byte[] temp = bi.toByteArray();
        if (temp.length > 32) {
            temp = Arrays.copyOfRange(temp, temp.length - 32, temp.length);
        }
        this.reverse(temp);
        if (temp.length < 32) {
            return Arrays.copyOf(temp, 32);
        }
        return temp;
    }

    public static byte[] getPublicKey(byte[] privateKey) {
        byte[] IL = Arrays.copyOfRange(privateKey, 0, 32);
        byte[] A = ED25519SPEC.getB().scalarMultiply(IL).toByteArray();
        return A;
    }
}

