/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function;

import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.helper.FeeCalculationService;
import com.bloxbean.cardano.client.api.helper.TransactionBuilder;
import com.bloxbean.cardano.client.api.helper.impl.FeeCalculationServiceImpl;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.coinselection.UtxoSelector;
import com.bloxbean.cardano.client.coinselection.impl.DefaultUtxoSelectionStrategyImpl;
import com.bloxbean.cardano.client.coinselection.impl.DefaultUtxoSelector;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxSigner;
import com.bloxbean.cardano.client.transaction.spec.CostMdls;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import java.util.ArrayList;
import java.util.List;

public class TxBuilderContext {
    private UtxoSupplier utxoSupplier;
    private ProtocolParams protocolParams;
    private UtxoSelectionStrategy utxoSelectionStrategy;
    private UtxoSelector utxoSelector;
    private FeeCalculationService feeCalculationService;
    private CostMdls costMdls;
    private List<MultiAsset> mintMultiAssets = new ArrayList<MultiAsset>();

    public TxBuilderContext(UtxoSupplier utxoSupplier, ProtocolParamsSupplier protocolParamsSupplier) {
        this(utxoSupplier, protocolParamsSupplier.getProtocolParams());
    }

    public TxBuilderContext(UtxoSupplier utxoSupplier, ProtocolParams protocolParams) {
        this.utxoSupplier = utxoSupplier;
        this.protocolParams = protocolParams;
        this.utxoSelectionStrategy = new DefaultUtxoSelectionStrategyImpl(utxoSupplier);
        this.utxoSelector = new DefaultUtxoSelector(utxoSupplier);
        this.feeCalculationService = new FeeCalculationServiceImpl(new TransactionBuilder(utxoSupplier, () -> protocolParams));
    }

    public void setUtxoSelectionStrategy(UtxoSelectionStrategy utxoSelectionStrategy) {
        this.utxoSelectionStrategy = utxoSelectionStrategy;
    }

    public UtxoSelectionStrategy getUtxoSelectionStrategy() {
        return this.utxoSelectionStrategy;
    }

    public ProtocolParams getProtocolParams() {
        return this.protocolParams;
    }

    public void addMintMultiAsset(MultiAsset multiAsset) {
        this.mintMultiAssets = MultiAsset.mergeMultiAssetLists(this.mintMultiAssets, List.of(multiAsset));
    }

    public List<MultiAsset> getMintMultiAssets() {
        return this.mintMultiAssets;
    }

    public void clearMintMultiAssets() {
        this.mintMultiAssets.clear();
    }

    public void setCostMdls(CostMdls costMdls) {
        this.costMdls = costMdls;
    }

    public static TxBuilderContext init(UtxoSupplier utxoSupplier, ProtocolParams protocolParams) {
        return new TxBuilderContext(utxoSupplier, protocolParams);
    }

    public static TxBuilderContext init(UtxoSupplier utxoSupplier, ProtocolParamsSupplier protocolParamsSupplier) {
        return new TxBuilderContext(utxoSupplier, protocolParamsSupplier);
    }

    public Transaction build(TxBuilder txBuilder) {
        Transaction transaction = new Transaction();
        txBuilder.apply(this, transaction);
        return transaction;
    }

    public Transaction buildAndSign(TxBuilder txBuilder, TxSigner signer) {
        Transaction transaction = this.build(txBuilder);
        return signer.sign(transaction);
    }

    public void build(Transaction transaction, TxBuilder txBuilder) {
        txBuilder.apply(this, transaction);
    }

    public UtxoSupplier getUtxoSupplier() {
        return this.utxoSupplier;
    }

    public UtxoSelector getUtxoSelector() {
        return this.utxoSelector;
    }

    public FeeCalculationService getFeeCalculationService() {
        return this.feeCalculationService;
    }

    public CostMdls getCostMdls() {
        return this.costMdls;
    }

    public void setUtxoSupplier(UtxoSupplier utxoSupplier) {
        this.utxoSupplier = utxoSupplier;
    }

    public void setProtocolParams(ProtocolParams protocolParams) {
        this.protocolParams = protocolParams;
    }

    public void setUtxoSelector(UtxoSelector utxoSelector) {
        this.utxoSelector = utxoSelector;
    }

    public void setFeeCalculationService(FeeCalculationService feeCalculationService) {
        this.feeCalculationService = feeCalculationService;
    }

    public void setMintMultiAssets(List<MultiAsset> mintMultiAssets) {
        this.mintMultiAssets = mintMultiAssets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxBuilderContext)) {
            return false;
        }
        TxBuilderContext other = (TxBuilderContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UtxoSupplier this$utxoSupplier = this.getUtxoSupplier();
        UtxoSupplier other$utxoSupplier = other.getUtxoSupplier();
        if (this$utxoSupplier == null ? other$utxoSupplier != null : !this$utxoSupplier.equals(other$utxoSupplier)) {
            return false;
        }
        ProtocolParams this$protocolParams = this.getProtocolParams();
        ProtocolParams other$protocolParams = other.getProtocolParams();
        if (this$protocolParams == null ? other$protocolParams != null : !((Object)this$protocolParams).equals(other$protocolParams)) {
            return false;
        }
        UtxoSelectionStrategy this$utxoSelectionStrategy = this.getUtxoSelectionStrategy();
        UtxoSelectionStrategy other$utxoSelectionStrategy = other.getUtxoSelectionStrategy();
        if (this$utxoSelectionStrategy == null ? other$utxoSelectionStrategy != null : !this$utxoSelectionStrategy.equals(other$utxoSelectionStrategy)) {
            return false;
        }
        UtxoSelector this$utxoSelector = this.getUtxoSelector();
        UtxoSelector other$utxoSelector = other.getUtxoSelector();
        if (this$utxoSelector == null ? other$utxoSelector != null : !this$utxoSelector.equals(other$utxoSelector)) {
            return false;
        }
        FeeCalculationService this$feeCalculationService = this.getFeeCalculationService();
        FeeCalculationService other$feeCalculationService = other.getFeeCalculationService();
        if (this$feeCalculationService == null ? other$feeCalculationService != null : !this$feeCalculationService.equals(other$feeCalculationService)) {
            return false;
        }
        CostMdls this$costMdls = this.getCostMdls();
        CostMdls other$costMdls = other.getCostMdls();
        if (this$costMdls == null ? other$costMdls != null : !this$costMdls.equals(other$costMdls)) {
            return false;
        }
        List<MultiAsset> this$mintMultiAssets = this.getMintMultiAssets();
        List<MultiAsset> other$mintMultiAssets = other.getMintMultiAssets();
        return !(this$mintMultiAssets == null ? other$mintMultiAssets != null : !((Object)this$mintMultiAssets).equals(other$mintMultiAssets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxBuilderContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UtxoSupplier $utxoSupplier = this.getUtxoSupplier();
        result = result * 59 + ($utxoSupplier == null ? 43 : $utxoSupplier.hashCode());
        ProtocolParams $protocolParams = this.getProtocolParams();
        result = result * 59 + ($protocolParams == null ? 43 : ((Object)$protocolParams).hashCode());
        UtxoSelectionStrategy $utxoSelectionStrategy = this.getUtxoSelectionStrategy();
        result = result * 59 + ($utxoSelectionStrategy == null ? 43 : $utxoSelectionStrategy.hashCode());
        UtxoSelector $utxoSelector = this.getUtxoSelector();
        result = result * 59 + ($utxoSelector == null ? 43 : $utxoSelector.hashCode());
        FeeCalculationService $feeCalculationService = this.getFeeCalculationService();
        result = result * 59 + ($feeCalculationService == null ? 43 : $feeCalculationService.hashCode());
        CostMdls $costMdls = this.getCostMdls();
        result = result * 59 + ($costMdls == null ? 43 : $costMdls.hashCode());
        List<MultiAsset> $mintMultiAssets = this.getMintMultiAssets();
        result = result * 59 + ($mintMultiAssets == null ? 43 : ((Object)$mintMultiAssets).hashCode());
        return result;
    }

    public String toString() {
        return "TxBuilderContext(utxoSupplier=" + this.getUtxoSupplier() + ", protocolParams=" + this.getProtocolParams() + ", utxoSelectionStrategy=" + this.getUtxoSelectionStrategy() + ", utxoSelector=" + this.getUtxoSelector() + ", feeCalculationService=" + this.getFeeCalculationService() + ", costMdls=" + this.getCostMdls() + ", mintMultiAssets=" + this.getMintMultiAssets() + ")";
    }
}

