/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.helper.FeeCalculationService;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.helper.ScriptDataHashCalculator;
import com.bloxbean.cardano.client.transaction.spec.ExUnits;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Redeemer;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionBody;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class FeeCalculators {
    private static Account dummyAccount;

    public static TxBuilder feeCalculator(String changeAddress, int noOfSigners) {
        return (transactionContext, transaction) -> FeeCalculators.execute(transactionContext, transaction, changeAddress, noOfSigners, null);
    }

    public static TxBuilder feeCalculator(int noOfSigners, UpdateOutputFunction updateOutputWithFeeFunc) {
        return (transactionContext, transaction) -> FeeCalculators.execute(transactionContext, transaction, null, noOfSigners, updateOutputWithFeeFunc);
    }

    private static void execute(TxBuilderContext context, Transaction transaction, String changeAddress, int noOfSigners, UpdateOutputFunction updateOutputWithFeeFunc) {
        FeeCalculationService feeCalculationService = context.getFeeCalculationService();
        ScriptDataHashCalculator.calculateScriptDataHash(context, transaction);
        try {
            List<ExUnits> exUnits;
            List<Redeemer> redeemerList;
            TransactionBody tbody = transaction.getBody();
            Transaction clonedTxn = FeeCalculators.createTransactionWithDummyWitnesses(transaction, noOfSigners);
            BigInteger baseFee = feeCalculationService.calculateFee(clonedTxn);
            BigInteger scriptFee = BigInteger.ZERO;
            if (transaction.getWitnessSet() != null && (redeemerList = transaction.getWitnessSet().getRedeemers()) != null && redeemerList.size() > 0 && (exUnits = redeemerList.stream().map(redeemer -> redeemer.getExUnits()).collect(Collectors.toList())) != null) {
                scriptFee = feeCalculationService.calculateScriptFee(exUnits);
            }
            BigInteger totalFee = baseFee.add(scriptFee);
            tbody.setFee(totalFee);
            if (updateOutputWithFeeFunc == null) {
                tbody.getOutputs().stream().filter(output -> changeAddress.equals(output.getAddress())).max((to1, to2) -> to1.getValue().getCoin().compareTo(to2.getValue().getCoin())).ifPresentOrElse(output -> output.getValue().setCoin(output.getValue().getCoin().subtract(totalFee)), () -> {
                    Value value = new Value(BigInteger.ZERO.subtract(totalFee), new ArrayList<MultiAsset>());
                    TransactionOutput output = new TransactionOutput(changeAddress, value);
                    transaction.getBody().getOutputs().add(output);
                });
            } else {
                updateOutputWithFeeFunc.accept(totalFee, transaction.getBody().getOutputs());
            }
        }
        catch (ApiException apiException) {
            throw new ApiRuntimeException("Error in fee calculation", apiException);
        }
        catch (CborSerializationException e) {
            throw new CborRuntimeException("Error in fee calculation", e);
        }
    }

    private static Transaction createTransactionWithDummyWitnesses(Transaction transaction, int noOfSigners) {
        Transaction cloneTxn;
        try {
            BigInteger orginalFee = transaction.getBody().getFee();
            transaction.getBody().setFee(BigInteger.valueOf(170000L));
            cloneTxn = Transaction.deserialize(transaction.serialize());
            transaction.getBody().setFee(orginalFee);
        }
        catch (CborDeserializationException | CborSerializationException e) {
            throw new CborRuntimeException("Error cloning the transaction", e);
        }
        for (int i = 0; i < noOfSigners; ++i) {
            cloneTxn = FeeCalculators.getDummyAccount().sign(cloneTxn);
        }
        return cloneTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Account getDummyAccount() {
        if (dummyAccount != null) return dummyAccount;
        Class<FeeCalculators> clazz = FeeCalculators.class;
        synchronized (FeeCalculators.class) {
            if (dummyAccount != null) return dummyAccount;
            dummyAccount = new Account(Networks.testnet());
            // ** MonitorExit[var0] (shouldn't be in output)
            return dummyAccount;
        }
    }

    public static interface UpdateOutputFunction
    extends BiConsumer<BigInteger, List<TransactionOutput>> {
        @Override
        public void accept(BigInteger var1, List<TransactionOutput> var2);
    }
}

