/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import co.nstant.in.cbor.CborException;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.config.Configuration;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.TxInputBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.MinAdaCheckers;
import com.bloxbean.cardano.client.plutus.UtxoUtil;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.AssetUtil;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputBuilders {
    private static final Logger log = LoggerFactory.getLogger(InputBuilders.class);

    public static TxInputBuilder createFromSender(String sender, String changeAddress) {
        return (context, outputs) -> {
            if (outputs == null || outputs.size() == 0) {
                throw new TxBuildException("No output found. UtxoSelector transformer should be called after OutputTransformer");
            }
            Value value = Value.builder().coin(BigInteger.ZERO).multiAssets(new ArrayList<MultiAsset>()).build();
            value = outputs.stream().map(output -> output.getValue()).reduce(value, (value1, value2) -> value1.plus((Value)value2));
            List<MultiAsset> mintMultiAssets = context.getMintMultiAssets();
            if (mintMultiAssets != null && mintMultiAssets.size() > 0) {
                value = value.minus(new Value(BigInteger.ZERO, mintMultiAssets));
            }
            Set<Utxo> utxoSet = InputBuilders.getUtxosForValue(context, sender, value, Collections.EMPTY_SET);
            List<TransactionInput> _inputs = utxoSet.stream().map(utxo -> new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex())).collect(Collectors.toList());
            if (utxoSet != null && !utxoSet.isEmpty()) {
                TransactionOutput changeOutput = new TransactionOutput(changeAddress, new Value(BigInteger.ZERO, new ArrayList<MultiAsset>()));
                utxoSet.stream().forEach(utxo -> UtxoUtil.copyUtxoValuesToOutput(changeOutput, utxo));
                Value changedValue = changeOutput.getValue().minus(value);
                changeOutput.setValue(changedValue);
                BigInteger additionalLovelace = (BigInteger)MinAdaCheckers.minAdaChecker().apply(context, changeOutput);
                if (additionalLovelace.compareTo(BigInteger.ZERO) == 1) {
                    Value additionalValue = Value.builder().coin(additionalLovelace).build();
                    Set<Utxo> additionalUtxos = InputBuilders.getUtxosForValue(context, sender, additionalValue, utxoSet);
                    List additionalInputs = additionalUtxos.stream().map(utxo -> new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex())).collect(Collectors.toList());
                    additionalUtxos.stream().forEach(utxo -> UtxoUtil.copyUtxoValuesToOutput(changeOutput, utxo));
                    _inputs.addAll(additionalInputs);
                }
                return new TxInputBuilder.Result(_inputs, List.of(changeOutput));
            }
            log.warn("Empty input. In normal case, this should not happen.");
            return new TxInputBuilder.Result(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        };
    }

    private static Set<Utxo> getUtxosForValue(TxBuilderContext context, String sender, Value value, Set<Utxo> excludeUtxos) {
        List<Utxo> lovelaceUtxos;
        HashSet<Utxo> utxoSet = new HashSet<Utxo>();
        try {
            lovelaceUtxos = value.getCoin() != null && !value.getCoin().equals(BigInteger.ZERO) ? context.getUtxoSelectionStrategy().selectUtxos(sender, "lovelace", value.getCoin(), excludeUtxos) : Collections.EMPTY_LIST;
        }
        catch (ApiException apiException) {
            throw new ApiRuntimeException(apiException);
        }
        List multiAssetUtoxs = value.getMultiAssets().stream().flatMap(multiAsset -> multiAsset.getAssets().stream().filter(asset -> !asset.getValue().equals(BigInteger.ZERO)).map(asset -> new Tuple<String, Asset>(multiAsset.getPolicyId(), (Asset)asset))).map(tuple -> {
            String unit = AssetUtil.getUnit((String)tuple._1, (Asset)tuple._2);
            try {
                List<Utxo> utxoList = context.getUtxoSelectionStrategy().selectUtxos(sender, unit, ((Asset)tuple._2).getValue(), excludeUtxos);
                if (utxoList != null && utxoList.size() != 0) {
                    return utxoList;
                }
                throw new ApiRuntimeException(String.format("No utxo found at address=%s, unit= %s, value=%s", sender, unit, ((Asset)tuple._2).getValue()));
            }
            catch (ApiException apiException) {
                throw new ApiRuntimeException("Error fetching utxos for qty: " + tuple._2 + ", and asset: " + tuple._2, apiException);
            }
        }).flatMap(list -> list.stream()).collect(Collectors.toList());
        utxoSet.addAll(lovelaceUtxos);
        utxoSet.addAll(multiAssetUtoxs);
        return utxoSet;
    }

    public static TxInputBuilder createFromUtxos(List<Utxo> utxos, String changeAddress) {
        return InputBuilders.createFromUtxos(utxos, changeAddress, null);
    }

    public static TxInputBuilder createFromUtxos(List<Utxo> utxos, String changeAddress, Object datum) {
        if (datum == null) {
            return InputBuilders.createFromUtxos(utxos, changeAddress, null);
        }
        try {
            String datumHash = Configuration.INSTANCE.getPlutusObjectConverter().toPlutusData(datum).getDatumHash();
            return InputBuilders.createFromUtxos(utxos, changeAddress, datumHash);
        }
        catch (CborException | CborSerializationException e) {
            throw new CborRuntimeException("Cbor serialization exeception ", (Exception)e);
        }
    }

    public static TxInputBuilder createFromUtxos(List<Utxo> utxos, String changeAddress, String datumHash) {
        return InputBuilders.createFromUtxos(() -> utxos, changeAddress, datumHash);
    }

    public static TxInputBuilder createFromUtxos(Supplier<List<Utxo>> supplier, String changeAddress, String datumHash) {
        return (context, outputs) -> {
            Value value = Value.builder().coin(BigInteger.ZERO).multiAssets(new ArrayList<MultiAsset>()).build();
            value = outputs.stream().map(output -> output.getValue()).reduce(value, (value1, value2) -> value1.plus((Value)value2));
            List utxos = (List)supplier.get();
            List<TransactionInput> _inputs = utxos.stream().map(utxo -> new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex())).collect(Collectors.toList());
            ArrayList<TransactionOutput> changeOutputs = new ArrayList<TransactionOutput>();
            if (changeAddress != null && !changeAddress.isEmpty()) {
                TransactionOutput changeOutput = new TransactionOutput(changeAddress, new Value(BigInteger.ZERO, new ArrayList<MultiAsset>()));
                utxos.stream().forEach(utxo -> UtxoUtil.copyUtxoValuesToOutput(changeOutput, utxo));
                Value changedValue = changeOutput.getValue().minus(value);
                changeOutput.setValue(changedValue);
                if (datumHash != null && !datumHash.isEmpty()) {
                    changeOutput.setDatumHash(HexUtil.decodeHexString(datumHash));
                }
                if (!changeOutput.getValue().getCoin().equals(BigInteger.ZERO) || changeOutput.getValue().getMultiAssets() != null && changeOutput.getValue().getMultiAssets().size() > 0) {
                    changeOutputs.add(changeOutput);
                }
            }
            return new TxInputBuilder.Result(_inputs, changeOutputs);
        };
    }

    public static TxInputBuilder createFromUtxos(List<Utxo> utxos) {
        return (context, outputs) -> {
            ArrayList<TransactionInput> inputs = new ArrayList<TransactionInput>();
            utxos.forEach(utxo -> {
                TransactionInput input = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
                inputs.add(input);
            });
            return new TxInputBuilder.Result(inputs, Collections.EMPTY_LIST);
        };
    }

    public static TxInputBuilder createFromUtxos(Supplier<List<Utxo>> supplier) {
        return (context, outputs) -> {
            ArrayList<TransactionInput> inputs = new ArrayList<TransactionInput>();
            ((List)supplier.get()).forEach(utxo -> {
                TransactionInput input = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
                inputs.add(input);
            });
            return new TxInputBuilder.Result(inputs, Collections.EMPTY_LIST);
        };
    }

    public static TxBuilder referenceInputsFromUtxos(Supplier<List<Utxo>> supplier) {
        return (context, transaction) -> InputBuilders.referenceInputsFromUtxos((List)supplier.get()).apply(context, transaction);
    }

    public static TxBuilder referenceInputsFromUtxos(List<Utxo> utxos) {
        return (context, transaction) -> {
            if (utxos == null || utxos.isEmpty()) {
                return;
            }
            ArrayList<TransactionInput> referenceInputs = new ArrayList<TransactionInput>();
            utxos.forEach(utxo -> {
                TransactionInput input = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
                referenceInputs.add(input);
            });
            if (transaction.getBody().getReferenceInputs() == null) {
                transaction.getBody().setReferenceInputs(referenceInputs);
            } else {
                transaction.getBody().getReferenceInputs().addAll(referenceInputs);
            }
        };
    }

    public static TxBuilder referenceInputsFrom(List<TransactionInput> referenceInputs) {
        return (context, transaction) -> {
            if (transaction.getBody().getReferenceInputs() == null) {
                transaction.getBody().setReferenceInputs(referenceInputs);
            } else {
                transaction.getBody().getReferenceInputs().addAll(referenceInputs);
            }
        };
    }
}

