/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.common.MinAdaCalculator;
import com.bloxbean.cardano.client.function.MinAdaChecker;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import java.math.BigInteger;

public class MinAdaCheckers {
    public static MinAdaChecker minAdaChecker() {
        return MinAdaCheckers::checkMinAdaRequirement;
    }

    private static BigInteger checkMinAdaRequirement(TxBuilderContext context, TransactionOutput output) {
        MinAdaCalculator minAdaCalculator = new MinAdaCalculator(context.getProtocolParams());
        BigInteger minAda = minAdaCalculator.calculateMinAda(output);
        if (minAda.compareTo(output.getValue().getCoin()) == 1) {
            return minAda.subtract(output.getValue().getCoin());
        }
        return BigInteger.ZERO;
    }
}

