/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.config.Configuration;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.RedeemerUtil;
import com.bloxbean.cardano.client.function.helper.model.ScriptCallContext;
import com.bloxbean.cardano.client.transaction.spec.ExUnits;
import com.bloxbean.cardano.client.transaction.spec.PlutusData;
import com.bloxbean.cardano.client.transaction.spec.PlutusScript;
import com.bloxbean.cardano.client.transaction.spec.PlutusV1Script;
import com.bloxbean.cardano.client.transaction.spec.PlutusV2Script;
import com.bloxbean.cardano.client.transaction.spec.Redeemer;
import com.bloxbean.cardano.client.transaction.spec.RedeemerTag;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import java.math.BigInteger;
import java.util.Objects;

public class ScriptCallContextProviders {
    public static TxBuilder createFromScriptCallContext(ScriptCallContext sc) {
        return ScriptCallContextProviders.scriptCallContext(sc.getScript(), sc.getUtxo(), sc.getDatum(), sc.getRedeemer(), sc.getRedeemerTag(), sc.getExUnits());
    }

    public static <T, K> TxBuilder scriptCallContext(PlutusScript plutusScript, Utxo utxo, T datum, K redeemerData, RedeemerTag tag, ExUnits exUnits) {
        return (context, transaction) -> {
            int scriptInputIndex = -1;
            if (utxo != null && (scriptInputIndex = RedeemerUtil.getScriptInputIndex(utxo, transaction)) == -1) {
                throw new TxBuildException("Script utxo is not found in transaction inputs : " + utxo.getTxHash());
            }
            ScriptCallContextProviders.scriptCallContext(plutusScript, scriptInputIndex, datum, redeemerData, tag, exUnits).apply(context, transaction);
        };
    }

    public static <T, K> TxBuilder scriptCallContext(PlutusScript plutusScript, int scriptInputIndex, T datum, K redeemerData, RedeemerTag tag, ExUnits exUnits) {
        Objects.requireNonNull(plutusScript);
        Objects.requireNonNull(tag);
        Objects.requireNonNull(exUnits);
        return (context, transaction) -> {
            if (transaction.getWitnessSet() == null) {
                transaction.setWitnessSet(new TransactionWitnessSet());
            }
            if (datum != null) {
                PlutusData datumPlutusData = datum instanceof PlutusData ? (PlutusData)datum : Configuration.INSTANCE.getPlutusObjectConverter().toPlutusData(datum);
                transaction.getWitnessSet().getPlutusDataList().add(datumPlutusData);
            }
            if (redeemerData != null) {
                PlutusData redeemerPlutusData = redeemerData instanceof PlutusData ? (PlutusData)redeemerData : Configuration.INSTANCE.getPlutusObjectConverter().toPlutusData(redeemerData);
                Redeemer redeemer = Redeemer.builder().tag(tag).data(redeemerPlutusData).index(scriptInputIndex != -1 ? BigInteger.valueOf(scriptInputIndex) : BigInteger.ZERO).exUnits(exUnits).build();
                transaction.getWitnessSet().getRedeemers().add(redeemer);
            }
            if (plutusScript instanceof PlutusV1Script) {
                if (!transaction.getWitnessSet().getPlutusV1Scripts().contains(plutusScript)) {
                    transaction.getWitnessSet().getPlutusV1Scripts().add((PlutusV1Script)plutusScript);
                }
            } else if (plutusScript instanceof PlutusV2Script && !transaction.getWitnessSet().getPlutusV2Scripts().contains(plutusScript)) {
                transaction.getWitnessSet().getPlutusV2Scripts().add((PlutusV2Script)plutusScript);
            }
        };
    }
}

