/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import co.nstant.in.cbor.CborException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.transaction.spec.CostMdls;
import com.bloxbean.cardano.client.transaction.spec.CostModel;
import com.bloxbean.cardano.client.transaction.spec.Language;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.util.CostModelUtil;
import com.bloxbean.cardano.client.transaction.util.ScriptDataHashGenerator;
import java.util.Optional;

public class ScriptDataHashCalculator {
    public static TxBuilder calculateScriptDataHash() {
        return (context, txn) -> ScriptDataHashCalculator.calculateScriptDataHash(context, txn);
    }

    public static void calculateScriptDataHash(TxBuilderContext ctx, Transaction transaction) {
        CostMdls costMdls;
        boolean containsPlutusScript = false;
        if (transaction.getWitnessSet().getPlutusV1Scripts() != null && transaction.getWitnessSet().getPlutusV1Scripts().size() > 0 || transaction.getWitnessSet().getPlutusV2Scripts() != null && transaction.getWitnessSet().getPlutusV2Scripts().size() > 0 || transaction.getWitnessSet().getRedeemers() != null && transaction.getWitnessSet().getRedeemers().size() > 0) {
            containsPlutusScript = true;
        }
        if ((costMdls = ctx.getCostMdls()) == null) {
            Optional<CostModel> costModel;
            costMdls = new CostMdls();
            if (transaction.getWitnessSet().getPlutusV1Scripts() != null && transaction.getWitnessSet().getPlutusV1Scripts().size() > 0) {
                costModel = CostModelUtil.getCostModelFromProtocolParams(ctx.getProtocolParams(), Language.PLUTUS_V1);
                costMdls.add(costModel.orElse(CostModelUtil.PlutusV1CostModel));
            }
            if (transaction.getWitnessSet().getPlutusV2Scripts() != null && transaction.getWitnessSet().getPlutusV2Scripts().size() > 0) {
                costModel = CostModelUtil.getCostModelFromProtocolParams(ctx.getProtocolParams(), Language.PLUTUS_V2);
                costMdls.add(costModel.orElse(CostModelUtil.PlutusV2CostModel));
            }
            if (costMdls.isEmpty() && transaction.getBody().getReferenceInputs() != null && transaction.getBody().getReferenceInputs().size() > 0) {
                costModel = CostModelUtil.getCostModelFromProtocolParams(ctx.getProtocolParams(), Language.PLUTUS_V2);
                costMdls.add(costModel.orElse(CostModelUtil.PlutusV2CostModel));
            }
        }
        if (containsPlutusScript) {
            byte[] scriptDataHash;
            try {
                scriptDataHash = ScriptDataHashGenerator.generate(transaction.getWitnessSet().getRedeemers(), transaction.getWitnessSet().getPlutusDataList(), costMdls.getLanguageViewEncoding());
            }
            catch (CborException | CborSerializationException e) {
                throw new CborRuntimeException((Exception)e);
            }
            transaction.getBody().setScriptDataHash(scriptDataHash);
        }
    }
}

