/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.metadata.cbor;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataList;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import com.bloxbean.cardano.client.metadata.cbor.MetadataHelper;
import com.bloxbean.cardano.client.metadata.exception.MetadataDeSerializationException;
import com.bloxbean.cardano.client.metadata.exception.MetadataSerializationException;
import com.bloxbean.cardano.client.metadata.helper.MetadataToJsonNoSchemaConverter;
import com.bloxbean.cardano.client.transaction.util.CborSerializationUtil;
import com.bloxbean.cardano.client.util.JsonUtil;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class CBORMetadata
implements Metadata {
    private Map map;

    public CBORMetadata() {
        this.map = new Map();
    }

    public CBORMetadata(Map map) {
        this.map = map;
    }

    public CBORMetadata put(BigInteger key, BigInteger value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new UnsignedInteger(value));
        return this;
    }

    public CBORMetadata putNegative(BigInteger key, BigInteger value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new NegativeInteger(value));
        return this;
    }

    public CBORMetadata put(BigInteger key, byte[] value) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new ByteString(value));
        return this;
    }

    public CBORMetadata put(BigInteger key, String value) {
        MetadataHelper.checkLength(value);
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)new UnicodeString(value));
        return this;
    }

    public CBORMetadata put(BigInteger key, CBORMetadataMap mm) {
        if (this.map != null) {
            this.map.put((DataItem)new UnsignedInteger(key), (DataItem)mm.getMap());
        }
        return this;
    }

    public CBORMetadata put(BigInteger key, CBORMetadataList list) {
        this.map.put((DataItem)new UnsignedInteger(key), (DataItem)list.getArray());
        return this;
    }

    public Object get(BigInteger key) {
        return MetadataHelper.extractActualValue(this.getData().get(MetadataHelper.objectToDataItem(key)));
    }

    public void remove(BigInteger key) {
        this.getData().remove(MetadataHelper.objectToDataItem(key));
    }

    public List keys() {
        return this.getData().getKeys().stream().map(di -> MetadataHelper.extractActualValue(di)).collect(Collectors.toList());
    }

    @Override
    public Map getData() throws MetadataSerializationException {
        return this.map;
    }

    @Override
    public byte[] serialize() throws MetadataSerializationException {
        try {
            return CborSerializationUtil.serialize((DataItem)this.map);
        }
        catch (Exception ex) {
            throw new MetadataSerializationException("CBOR serialization exception ", ex);
        }
    }

    @Override
    public Metadata merge(Metadata other) {
        CBORMetadata newMetadata = new CBORMetadata();
        if (other != null) {
            Map otherMap = other.getData();
            otherMap.getKeys().forEach(key -> newMetadata.getData().put(key, otherMap.get(key)));
        }
        this.map.getKeys().forEach(key -> newMetadata.getData().put(key, this.map.get(key)));
        return newMetadata;
    }

    public static CBORMetadata deserialize(Map metadataMap) throws MetadataDeSerializationException {
        CBORMetadata cborMetadata = new CBORMetadata();
        Collection keys = metadataMap.getKeys();
        for (DataItem keyDI : keys) {
            DataItem valueDI = metadataMap.get(keyDI);
            BigInteger key = ((UnsignedInteger)keyDI).getValue();
            if (MajorType.UNSIGNED_INTEGER.equals((Object)valueDI.getMajorType())) {
                cborMetadata.put(key, ((UnsignedInteger)valueDI).getValue());
                continue;
            }
            if (MajorType.NEGATIVE_INTEGER.equals((Object)valueDI.getMajorType())) {
                cborMetadata.putNegative(key, ((NegativeInteger)valueDI).getValue());
                continue;
            }
            if (MajorType.BYTE_STRING.equals((Object)valueDI.getMajorType())) {
                cborMetadata.put(key, ((ByteString)valueDI).getBytes());
                continue;
            }
            if (MajorType.UNICODE_STRING.equals((Object)valueDI.getMajorType())) {
                cborMetadata.put(key, ((UnicodeString)valueDI).getString());
                continue;
            }
            if (MajorType.MAP.equals((Object)valueDI.getMajorType())) {
                CBORMetadataMap cborMetadataMap = new CBORMetadataMap((Map)valueDI);
                cborMetadata.put(key, cborMetadataMap);
                continue;
            }
            if (MajorType.ARRAY.equals((Object)valueDI.getMajorType())) {
                CBORMetadataList cborMetadataList = new CBORMetadataList((Array)valueDI);
                cborMetadata.put(key, cborMetadataList);
                continue;
            }
            throw new MetadataDeSerializationException("Unsupported type : " + valueDI.getMajorType());
        }
        return cborMetadata;
    }

    public static CBORMetadata deserialize(byte[] cborBytes) throws MetadataDeSerializationException {
        List dataItemList = null;
        try {
            dataItemList = CborDecoder.decode((byte[])cborBytes);
        }
        catch (CborException e) {
            throw new MetadataDeSerializationException("Cbor deserialization failed", (Exception)((Object)e));
        }
        if (dataItemList == null || dataItemList.size() == 0) {
            throw new MetadataDeSerializationException("Cbor deserialization failed. Null dataitem");
        }
        if (dataItemList.size() > 1) {
            throw new MetadataDeSerializationException("Multiple DataItems found at top level. Should be one : " + dataItemList.size());
        }
        DataItem di = (DataItem)dataItemList.get(0);
        if (di instanceof Map) {
            return CBORMetadata.deserialize((Map)di);
        }
        throw new MetadataDeSerializationException("Unknown data type at the top level. Should be a Map. " + di.getClass());
    }

    @Override
    public byte[] getMetadataHash() throws MetadataSerializationException {
        byte[] encodedBytes = this.serialize();
        return Blake2bUtil.blake2bHash256(encodedBytes);
    }

    public String toJson() {
        String json = MetadataToJsonNoSchemaConverter.cborBytesToJson(this.serialize());
        return JsonUtil.getPrettyJson(json);
    }
}

