/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus;

import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.util.AssetUtil;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class UtxoUtil {
    public static void copyUtxoValuesToOutput(TransactionOutput output, Utxo utxo) {
        utxo.getAmount().forEach(utxoAmt -> {
            String utxoUnit = utxoAmt.getUnit();
            BigInteger utxoQty = utxoAmt.getQuantity();
            if (utxoUnit.equals("lovelace")) {
                BigInteger existingCoin = output.getValue().getCoin();
                if (existingCoin == null) {
                    existingCoin = BigInteger.ZERO;
                }
                output.getValue().setCoin(existingCoin.add(utxoQty));
            } else {
                Tuple<String, String> policyIdAssetName = AssetUtil.getPolicyIdAndAssetName(utxoUnit);
                Optional<MultiAsset> multiAssetOptional = output.getValue().getMultiAssets().stream().filter(ma -> ((String)policyIdAssetName._1).equals(ma.getPolicyId())).findFirst();
                if (multiAssetOptional.isPresent()) {
                    Optional<Asset> assetOptional = multiAssetOptional.get().getAssets().stream().filter(ast -> ((String)policyIdAssetName._2).equals(ast.getName())).findFirst();
                    if (assetOptional.isPresent()) {
                        BigInteger changeVal = assetOptional.get().getValue().add(utxoQty);
                        assetOptional.get().setValue(changeVal);
                    } else {
                        Asset asset = new Asset((String)policyIdAssetName._2, utxoQty);
                        multiAssetOptional.get().getAssets().add(asset);
                    }
                } else {
                    Asset asset = new Asset((String)policyIdAssetName._2, utxoQty);
                    MultiAsset multiAsset = new MultiAsset((String)policyIdAssetName._1, new ArrayList<Asset>(Arrays.asList(asset)));
                    output.getValue().getMultiAssets().add(multiAsset);
                }
            }
        });
        List<MultiAsset> multiAssets = output.getValue().getMultiAssets();
        ArrayList markedForRemoval = new ArrayList();
        if (multiAssets != null && multiAssets.size() > 0) {
            multiAssets.forEach(ma -> {
                if (ma.getAssets() == null || ma.getAssets().size() == 0) {
                    markedForRemoval.add(ma);
                }
            });
            if (markedForRemoval != null && !markedForRemoval.isEmpty()) {
                multiAssets.removeAll(markedForRemoval);
            }
        }
    }
}

